/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.ReceiveStream;
import org.jitsi.impl.neomedia.protocol.NullBufferTransferHandler;
import org.jitsi.impl.neomedia.protocol.PushBufferDataSourceDelegate;

public class ReceiveStreamPushBufferDataSource
extends PushBufferDataSourceDelegate<PushBufferDataSource> {
    private final ReceiveStream receiveStream;
    private boolean suppressDisconnect;

    public static void setNullTransferHandler(ReceiveStream receiveStream) {
        DataSource dataSource = receiveStream.getDataSource();
        if (dataSource != null && dataSource instanceof PushBufferDataSource) {
            PushBufferStream[] streams = ((PushBufferDataSource)dataSource).getStreams();
            if (streams != null && streams.length != 0) {
                for (PushBufferStream stream : streams) {
                    stream.setTransferHandler(new NullBufferTransferHandler());
                }
            }
            if (dataSource instanceof net.sf.fmj.media.protocol.rtp.DataSource) {
                ((net.sf.fmj.media.protocol.rtp.DataSource)dataSource).setBufferWhenStopped(false);
            }
        }
    }

    public ReceiveStreamPushBufferDataSource(ReceiveStream receiveStream, PushBufferDataSource dataSource) {
        super(dataSource);
        this.receiveStream = receiveStream;
    }

    public ReceiveStreamPushBufferDataSource(ReceiveStream receiveStream, PushBufferDataSource dataSource, boolean suppressDisconnect) {
        this(receiveStream, dataSource);
        this.setSuppressDisconnect(suppressDisconnect);
    }

    @Override
    public void disconnect() {
        if (!this.suppressDisconnect) {
            super.disconnect();
        }
    }

    public ReceiveStream getReceiveStream() {
        return this.receiveStream;
    }

    @Override
    public PushBufferStream[] getStreams() {
        return ((PushBufferDataSource)this.dataSource).getStreams();
    }

    public void setSuppressDisconnect(boolean suppressDisconnect) {
        this.suppressDisconnect = suppressDisconnect;
    }
}

