/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import org.freedesktop.dbus.MethodCall;

class EfficientMap {
    private long[] kv;
    private MethodCall[] vv;
    private int start;
    private int end;
    private int init_size;

    public EfficientMap(int n) {
        this.init_size = n;
        this.shrink();
    }

    private void grow() {
        long[] lArray = this.kv;
        this.kv = new long[lArray.length * 2];
        MethodCall[] methodCallArray = this.vv;
        this.vv = new MethodCall[methodCallArray.length * 2];
        System.arraycopy(lArray, this.start, this.kv, 0, lArray.length - this.start);
        System.arraycopy(methodCallArray, this.start, this.vv, 0, methodCallArray.length - this.start);
        if (this.end != lArray.length - 1) {
            System.arraycopy(lArray, 0, this.kv, lArray.length - this.start, this.end + 1);
            System.arraycopy(methodCallArray, 0, this.vv, methodCallArray.length - this.start, this.end + 1);
        }
        this.start = 0;
        this.end = lArray.length;
    }

    public long[] getKeys() {
        int n = this.start < this.end ? this.end - this.start : this.kv.length - (this.start - this.end);
        long[] lArray = new long[n];
        int n2 = n > this.kv.length - this.start ? this.kv.length - this.start : n;
        System.arraycopy(this.kv, this.start, lArray, 0, n2);
        if (n2 < n) {
            System.arraycopy(this.kv, 0, lArray, n2, n - n2);
        }
        return lArray;
    }

    private void shrink() {
        if (null != this.kv && this.kv.length == this.init_size) {
            return;
        }
        this.kv = new long[this.init_size];
        this.vv = new MethodCall[this.init_size];
        this.start = 0;
        this.end = 0;
    }

    public void put(long l, MethodCall methodCall) {
        this.kv[this.end] = l;
        this.vv[this.end] = methodCall;
        this.end = this.end == this.kv.length - 1 ? 0 : ++this.end;
        if (this.end == this.start) {
            this.grow();
        }
    }

    public MethodCall remove(long l) {
        int n = this.find(l);
        if (-1 == n) {
            return null;
        }
        MethodCall methodCall = this.vv[n];
        this.vv[n] = null;
        this.kv[n] = -1L;
        while (-1L == this.kv[this.start]) {
            this.start = this.start == this.kv.length - 1 ? 0 : ++this.start;
            if (this.start != this.end) continue;
            this.shrink();
            break;
        }
        return methodCall;
    }

    public boolean contains(long l) {
        return -1 != this.find(l);
    }

    private int find(long l) {
        int n = this.start;
        while (n != this.end && this.kv[n] != l) {
            if (n == this.kv.length - 1) {
                n = 0;
                continue;
            }
            ++n;
        }
        if (n == this.end) {
            return -1;
        }
        return n;
    }
}

