/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.DynamicByteBuffer;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.DefaultPortableReader;
import com.hazelcast.nio.serialization.DefaultPortableWriter;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.MorphingPortableReader;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.serialization.PortableDataInput;
import com.hazelcast.nio.serialization.PortableDataOutput;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableVersionHelper;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

final class PortableSerializer
implements StreamSerializer<Portable> {
    private final PortableContext context;
    private final Map<Integer, PortableFactory> factories = new HashMap<Integer, PortableFactory>();

    PortableSerializer(PortableContext context, Map<Integer, ? extends PortableFactory> portableFactories) {
        this.context = context;
        this.factories.putAll(portableFactories);
    }

    @Override
    public int getTypeId() {
        return -1;
    }

    @Override
    public void write(ObjectDataOutput out, Portable p) throws IOException {
        if (!(out instanceof PortableDataOutput)) {
            throw new IllegalArgumentException("ObjectDataOutput must be instance of PortableDataOutput!");
        }
        if (p.getClassId() == 0) {
            throw new IllegalArgumentException("Portable class id cannot be zero!");
        }
        ClassDefinition cd = this.context.lookupOrRegisterClassDefinition(p);
        PortableDataOutput output = (PortableDataOutput)out;
        DynamicByteBuffer headerBuffer = output.getHeaderBuffer();
        int pos = headerBuffer.position();
        out.writeInt(pos);
        headerBuffer.putInt(cd.getFactoryId());
        headerBuffer.putInt(cd.getClassId());
        headerBuffer.putInt(cd.getVersion());
        DefaultPortableWriter writer = new DefaultPortableWriter(this, output, cd);
        p.writePortable(writer);
        writer.end();
    }

    @Override
    public Portable read(ObjectDataInput in) throws IOException {
        if (!(in instanceof PortableDataInput)) {
            throw new IllegalArgumentException("ObjectDataInput must be instance of PortableDataInput!");
        }
        PortableDataInput input = (PortableDataInput)in;
        ByteBuffer headerBuffer = input.getHeaderBuffer();
        int pos = input.readInt();
        headerBuffer.position(pos);
        int factoryId = headerBuffer.getInt();
        int classId = headerBuffer.getInt();
        int version = headerBuffer.getInt();
        Portable portable = this.createNewPortableInstance(factoryId, classId);
        int portableVersion = this.findPortableVersion(factoryId, classId, portable);
        DefaultPortableReader reader = this.createReader(input, factoryId, classId, version, portableVersion);
        portable.readPortable(reader);
        reader.end();
        return portable;
    }

    private int findPortableVersion(int factoryId, int classId, Portable portable) {
        int currentVersion = this.context.getClassVersion(factoryId, classId);
        if (currentVersion < 0 && (currentVersion = PortableVersionHelper.getVersion(portable, this.context.getVersion())) > 0) {
            this.context.setClassVersion(factoryId, classId, currentVersion);
        }
        return currentVersion;
    }

    private Portable createNewPortableInstance(int factoryId, int classId) {
        PortableFactory portableFactory = this.factories.get(factoryId);
        if (portableFactory == null) {
            throw new HazelcastSerializationException("Could not find PortableFactory for factory-id: " + factoryId);
        }
        Portable portable = portableFactory.create(classId);
        if (portable == null) {
            throw new HazelcastSerializationException("Could not create Portable for class-id: " + classId);
        }
        return portable;
    }

    Portable readAndInitialize(BufferObjectDataInput in) throws IOException {
        Portable p = this.read(in);
        ManagedContext managedContext = this.context.getManagedContext();
        return managedContext != null ? (Portable)managedContext.initialize(p) : p;
    }

    DefaultPortableReader createReader(BufferObjectDataInput in) throws IOException {
        ByteBuffer headerBuffer = ((PortableDataInput)in).getHeaderBuffer();
        int pos = in.readInt();
        headerBuffer.position(pos);
        int factoryId = headerBuffer.getInt();
        int classId = headerBuffer.getInt();
        int version = headerBuffer.getInt();
        return this.createReader(in, factoryId, classId, version, version);
    }

    private DefaultPortableReader createReader(BufferObjectDataInput in, int factoryId, int classId, int version, int portableVersion) {
        ClassDefinition cd;
        int effectiveVersion = version;
        if (version < 0) {
            effectiveVersion = this.context.getVersion();
        }
        if ((cd = this.context.lookupClassDefinition(factoryId, classId, effectiveVersion)) == null) {
            throw new HazelcastSerializationException("Could not find class-definition for factory-id: " + factoryId + ", class-id: " + classId + ", version: " + effectiveVersion);
        }
        DefaultPortableReader reader = portableVersion == effectiveVersion ? new DefaultPortableReader(this, in, cd) : new MorphingPortableReader(this, in, cd);
        return reader;
    }

    @Override
    public void destroy() {
        this.factories.clear();
    }
}

