/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.util.LineTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class TailFilter
extends BaseParamFilterReader
implements ChainableReader {
    private static final String LINES_KEY = "lines";
    private static final String SKIP_KEY = "skip";
    private static final int DEFAULT_NUM_LINES = 10;
    private long lines;
    private long skip;
    private boolean completedReadAhead;
    private LineTokenizer lineTokenizer;
    private String line;
    private int linePos;
    private LinkedList lineList;

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        while (this.line == null || this.line.length() == 0) {
            this.line = this.lineTokenizer.getToken(this.in);
            this.line = this.tailFilter(this.line);
            if (this.line == null) {
                return -1;
            }
            this.linePos = 0;
        }
        char c = this.line.charAt(this.linePos);
        ++this.linePos;
        if (this.linePos == this.line.length()) {
            this.line = null;
        }
        return c;
    }

    public final void setLines(long l) {
        this.lines = l;
    }

    private final long getLines() {
        return this.lines;
    }

    public final void setSkip(long l) {
        this.skip = l;
    }

    private final long getSkip() {
        return this.skip;
    }

    public final Reader chain(Reader reader) {
        TailFilter tailFilter = new TailFilter(reader);
        tailFilter.setLines(this.getLines());
        tailFilter.setSkip(this.getSkip());
        tailFilter.setInitialized(true);
        return tailFilter;
    }

    private final void initialize() {
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                if (LINES_KEY.equals(parameterArray[n].getName())) {
                    this.setLines(new Long(parameterArray[n].getValue()));
                } else if (SKIP_KEY.equals(parameterArray[n].getName())) {
                    this.skip = new Long(parameterArray[n].getValue());
                }
                ++n;
            }
        }
    }

    private final String tailFilter(String string) {
        if (!this.completedReadAhead) {
            if (string != null) {
                this.lineList.add(string);
                if (this.lines == (long)-1) {
                    if ((long)this.lineList.size() > this.skip) {
                        return (String)this.lineList.removeFirst();
                    }
                } else {
                    long l = this.lines + (this.skip > 0L ? this.skip : 0L);
                    if (l < (long)this.lineList.size()) {
                        this.lineList.removeFirst();
                    }
                }
                return "";
            }
            this.completedReadAhead = true;
            if (this.skip > 0L) {
                int n = 0;
                while ((long)n < this.skip) {
                    this.lineList.removeLast();
                    ++n;
                }
            }
            if (this.lines > (long)-1) {
                while ((long)this.lineList.size() > this.lines) {
                    this.lineList.removeFirst();
                }
            }
        }
        if (this.lineList.size() > 0) {
            return (String)this.lineList.removeFirst();
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.lines = 10L;
        this.skip = 0L;
        this.completedReadAhead = false;
        this.lineTokenizer = null;
        this.line = null;
        this.linePos = 0;
        this.lineList = new LinkedList();
    }

    public TailFilter() {
        this.this();
    }

    public TailFilter(Reader reader) {
        super(reader);
        this.this();
        this.lineTokenizer = new LineTokenizer();
        this.lineTokenizer.setIncludeDelims(true);
    }
}

