/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.FileOptions;
import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.config.AssociationConfig;
import com.install4j.runtime.installer.config.BaseScreenConfig;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.CustomScreenConfig;
import com.install4j.runtime.installer.config.CustomTaskConfig;
import com.install4j.runtime.installer.config.FileOptionsConfig;
import com.install4j.runtime.installer.config.MacSpecificConfig;
import com.install4j.runtime.installer.config.MenuEntryConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.config.StandardScreenConfig;
import com.install4j.runtime.installer.config.UnixSpecificConfig;
import com.install4j.runtime.installer.config.WindowsSpecificConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nanoxml.XMLElement;

public class InstallerConfig
extends AbstractConfig {
    private static InstallerConfig currentConfig = null;
    private String type;
    private String locale = "en";
    private String applicationName = "";
    private String applicationVersion = "";
    private String defaultInstallationDirectory = "";
    private boolean allowUserStartAfterFinish = false;
    private String launchExecutable = "";
    private String preActionClass;
    private String postActionClass;
    private String uninstallPreActionClass;
    private String uninstallPostActionClass;
    private String installationHandlerClass;
    private String initHandlerClass;
    private boolean jreShared = false;
    private String jreVersion = "";
    private List screens;
    private List menuEntries;
    private List components = Collections.EMPTY_LIST;
    private List services = Collections.EMPTY_LIST;
    private List uninstallDeleteEntries;
    private String minJavaVersion = "";
    private boolean adminRequired = false;
    private String publisherName = "";
    private String publisherURL = "";
    private String mediaName = "";
    private boolean allowUnattended = false;
    private String uninstallerFilename = "";
    private String desktopExecutable = "";
    private boolean desktopIconIncluded = false;
    private boolean desktopIconSelected = false;
    private int windowWidth = 500;
    private int windowHeight = 390;
    private String installDirValidatorClass;
    private boolean suggestAppDir = true;
    private boolean showNeededSpace = true;
    private String status = "";
    private List customTasks = Collections.EMPTY_LIST;
    private List associations = Collections.EMPTY_LIST;
    private boolean customTasksPlaceBefore = true;
    private Map userVariables = new HashMap();
    private String applicationId = "";
    private int installerType;
    private boolean runUninstallerOnUpdate = false;
    private String addonAppId = "";
    private boolean suggestPreviousLocations = true;
    private boolean lzmaCompression = false;
    private FileOptionsConfig fileOptionsConfig = new FileOptionsConfig();
    private WindowsSpecificConfig windowsSpecificConfig = new WindowsSpecificConfig(this);
    private MacSpecificConfig macSpecificConfig = new MacSpecificConfig();
    private UnixSpecificConfig unixSpecificConfig = new UnixSpecificConfig();

    public static InstallerConfig getCurrentInstance() {
        if (currentConfig == null) {
            try {
                currentConfig = new InstallerConfig(InstallerUtil.getInstallerFile("i4jparams.conf"));
            }
            catch (IOException iOException) {
                GUIHelper.showMessage(null, "Internal error: Could not open config file.", 0);
                System.exit(1);
            }
        }
        return currentConfig;
    }

    public static InstallerConfig getInstanceFromFile(File file) throws IOException {
        return new InstallerConfig(file);
    }

    private InstallerConfig(File file) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseFromReader(inputStreamReader);
        this.read(xMLElement);
        inputStreamReader.close();
    }

    public String getLocale() {
        return this.locale;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public boolean isAdminRequired() {
        return this.adminRequired;
    }

    public String getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public boolean isAllowUnattended() {
        return this.allowUnattended;
    }

    public boolean isLzmaCompression() {
        return this.lzmaCompression;
    }

    public String getType() {
        return this.type;
    }

    public boolean isJreShared() {
        return this.jreShared;
    }

    public String getJreVersion() {
        return this.jreVersion;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationNameWithVersion() {
        String string = this.getApplicationName();
        if (this.getApplicationVersion().trim().length() > 0 && this.getApplicationName().indexOf(this.getApplicationVersion()) == -1) {
            string = string + " " + this.getApplicationVersion();
        }
        return string;
    }

    public String getDefaultInstallationDirectory() {
        return this.defaultInstallationDirectory;
    }

    public boolean isAllowUserStartAfterFinish() {
        return this.allowUserStartAfterFinish;
    }

    public String getLaunchExecutable() {
        return this.launchExecutable;
    }

    public String getPreActionClass() {
        return this.preActionClass;
    }

    public String getPostActionClass() {
        return this.postActionClass;
    }

    public String getUninstallPreActionClass() {
        return this.uninstallPreActionClass;
    }

    public String getUninstallPostActionClass() {
        return this.uninstallPostActionClass;
    }

    public String getInstallationHandlerClass() {
        return this.installationHandlerClass;
    }

    public String getInitHandlerClass() {
        return this.initHandlerClass;
    }

    public List getScreens() {
        return this.screens;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public String getPublisherURL() {
        return this.publisherURL;
    }

    public String getInstallDirValidatorClass() {
        return this.installDirValidatorClass;
    }

    public boolean isSuggestAppDir() {
        return this.suggestAppDir;
    }

    public boolean isShowNeededSpace() {
        return this.showNeededSpace;
    }

    public List getCustomTasks() {
        return this.customTasks;
    }

    public boolean isCustomTasksPlaceBefore() {
        return this.customTasksPlaceBefore;
    }

    public List getAssociations() {
        return this.associations;
    }

    public String getUninstallerFilename() {
        return this.uninstallerFilename;
    }

    public StandardScreenConfig getScreenForId(String string) {
        Iterator iterator = this.screens.iterator();
        while (iterator.hasNext()) {
            StandardScreenConfig standardScreenConfig;
            BaseScreenConfig baseScreenConfig = (BaseScreenConfig)iterator.next();
            if (!(baseScreenConfig instanceof StandardScreenConfig) || !(standardScreenConfig = (StandardScreenConfig)baseScreenConfig).getId().equals(string)) continue;
            return standardScreenConfig;
        }
        return null;
    }

    public String getStatus() {
        return this.status;
    }

    public List getMenuEntries() {
        return this.menuEntries;
    }

    public List getComponents() {
        return this.components;
    }

    public List getServices() {
        return this.services;
    }

    public boolean isDesktopIconIncluded() {
        return this.desktopIconIncluded;
    }

    public boolean isDesktopIconSelected() {
        return this.desktopIconSelected;
    }

    public String getDesktopExecutable() {
        return this.desktopExecutable;
    }

    public List getUninstallDeleteEntries() {
        return this.uninstallDeleteEntries;
    }

    public FileOptions getOptions(String string) {
        return this.fileOptionsConfig.getOptions(string);
    }

    public FileOptionsConfig getFileOptionsConfig() {
        return this.fileOptionsConfig;
    }

    public WindowsSpecificConfig getWindowsSpecificConfig() {
        return this.windowsSpecificConfig;
    }

    public MacSpecificConfig getMacSpecificConfig() {
        return this.macSpecificConfig;
    }

    public UnixSpecificConfig getUnixSpecificConfig() {
        return this.unixSpecificConfig;
    }

    public Map getUserVariables() {
        return this.userVariables;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public int getInstallerType() {
        return this.installerType;
    }

    public boolean isRunUninstallerOnUpdate() {
        return this.runUninstallerOnUpdate;
    }

    public String getAddonAppId() {
        return this.addonAppId;
    }

    public boolean isSuggestPreviousLocations() {
        return this.suggestPreviousLocations;
    }

    protected void read(XMLElement xMLElement) {
        this.type = InstallerConfig.readAttribute(xMLElement, "type", this.type);
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = xMLElement2.getName();
            if (string.equals("general")) {
                this.readGeneral(xMLElement2);
                continue;
            }
            if (string.equals("variables")) {
                this.readVariables(xMLElement2);
                continue;
            }
            if (string.equals("screens")) {
                this.readScreens(xMLElement2);
                continue;
            }
            if (string.equals("fileOptions")) {
                this.fileOptionsConfig.read(xMLElement2);
                continue;
            }
            if (string.equals("menu")) {
                this.readMenu(xMLElement2);
                continue;
            }
            if (string.equals("components")) {
                this.readComponents(xMLElement2);
                continue;
            }
            if (string.equals("services")) {
                this.readServices(xMLElement2);
                continue;
            }
            if (string.equals("tasks")) {
                this.readTasks(xMLElement2);
                continue;
            }
            if (string.equals("associations")) {
                this.readAssociations(xMLElement2);
                continue;
            }
            if (string.equals("uninstallDelete")) {
                this.readUninstallDelete(xMLElement2);
                continue;
            }
            if (string.equals("windowsSpecific")) {
                this.windowsSpecificConfig.read(xMLElement2);
                continue;
            }
            if (string.equals("macSpecific")) {
                this.macSpecificConfig.read(xMLElement2);
                continue;
            }
            if (!string.equals("unixSpecific")) continue;
            this.unixSpecificConfig.read(xMLElement2);
        }
    }

    private void readGeneral(XMLElement xMLElement) {
        this.locale = InstallerConfig.readAttribute(xMLElement, "locale", this.locale);
        this.applicationName = InstallerConfig.readAttribute(xMLElement, "applicationName", this.applicationName);
        this.defaultInstallationDirectory = InstallerConfig.readAttribute(xMLElement, "defaultInstallationDirectory", this.defaultInstallationDirectory);
        this.allowUserStartAfterFinish = InstallerConfig.readAttribute(xMLElement, "allowUserStartAfterFinish", this.allowUserStartAfterFinish);
        this.launchExecutable = InstallerConfig.readAttribute(xMLElement, "launchExecutable", this.launchExecutable);
        this.status = InstallerConfig.readAttribute(xMLElement, "status", this.status);
        this.preActionClass = InstallerConfig.readAttribute(xMLElement, "preActionClass", this.preActionClass);
        this.postActionClass = InstallerConfig.readAttribute(xMLElement, "postActionClass", this.postActionClass);
        this.uninstallPreActionClass = InstallerConfig.readAttribute(xMLElement, "uninstallPreActionClass", this.uninstallPreActionClass);
        this.uninstallPostActionClass = InstallerConfig.readAttribute(xMLElement, "uninstallPostActionClass", this.uninstallPostActionClass);
        this.installationHandlerClass = InstallerConfig.readAttribute(xMLElement, "installationHandlerClass", this.installationHandlerClass);
        this.initHandlerClass = InstallerConfig.readAttribute(xMLElement, "initHandlerClass", this.initHandlerClass);
        this.jreShared = InstallerConfig.readAttribute(xMLElement, "jreShared", this.jreShared);
        this.jreVersion = InstallerConfig.readAttribute(xMLElement, "jreVersion", this.jreVersion);
        this.minJavaVersion = InstallerConfig.readAttribute(xMLElement, "minJavaVersion", this.minJavaVersion);
        this.adminRequired = InstallerConfig.readAttribute(xMLElement, "adminRequired", this.adminRequired);
        this.windowWidth = InstallerConfig.readAttribute(xMLElement, "windowWidth", this.windowWidth);
        this.windowHeight = InstallerConfig.readAttribute(xMLElement, "windowHeight", this.windowHeight);
        this.publisherName = InstallerConfig.readAttribute(xMLElement, "publisherName", this.publisherName);
        this.publisherURL = InstallerConfig.readAttribute(xMLElement, "publisherURL", this.publisherURL);
        this.installDirValidatorClass = InstallerConfig.readAttribute(xMLElement, "installDirValidatorClass", this.installDirValidatorClass);
        this.suggestAppDir = InstallerConfig.readAttribute(xMLElement, "suggestAppDir", this.suggestAppDir);
        this.showNeededSpace = InstallerConfig.readAttribute(xMLElement, "showNeededSpace", this.showNeededSpace);
        this.mediaName = InstallerConfig.readAttribute(xMLElement, "mediaName", this.mediaName);
        this.allowUnattended = InstallerConfig.readAttribute(xMLElement, "allowUnattended", this.allowUnattended);
        this.uninstallerFilename = InstallerConfig.readAttribute(xMLElement, "uninstallerFilename", this.uninstallerFilename);
        this.desktopExecutable = InstallerConfig.readAttribute(xMLElement, "mainExecutable", this.desktopExecutable);
        this.desktopIconIncluded = InstallerConfig.readAttribute(xMLElement, "desktopIconIncluded", this.desktopIconIncluded);
        this.desktopIconSelected = InstallerConfig.readAttribute(xMLElement, "desktopIconSelected", this.desktopIconSelected);
        this.applicationVersion = InstallerConfig.readAttribute(xMLElement, "applicationVersion", this.applicationVersion);
        this.lzmaCompression = InstallerConfig.readAttribute(xMLElement, "lzmaCompression", this.lzmaCompression);
        this.applicationId = InstallerConfig.readAttribute(xMLElement, "applicationId", this.applicationId);
        this.installerType = InstallerConfig.readAttribute(xMLElement, "installerType", this.installerType);
        this.runUninstallerOnUpdate = InstallerConfig.readAttribute(xMLElement, "runUninstaller", this.runUninstallerOnUpdate);
        this.addonAppId = InstallerConfig.readAttribute(xMLElement, "addOnAppId", this.addonAppId);
        this.suggestPreviousLocations = InstallerConfig.readAttribute(xMLElement, "suggestPreviousLocations", this.suggestPreviousLocations);
    }

    private void readVariables(XMLElement xMLElement) {
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = InstallerConfig.readAttribute(xMLElement2, "name", null);
            String string2 = InstallerConfig.readAttribute(xMLElement2, "value", null);
            if (string == null || string2 == null) continue;
            this.userVariables.put(string, string2);
        }
    }

    private void readScreens(XMLElement xMLElement) {
        LinkedList<StandardScreenConfig> linkedList = new LinkedList<StandardScreenConfig>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            BaseScreenConfig baseScreenConfig = null;
            String string = xMLElement2.getName();
            if (string.equals("standardScreen")) {
                baseScreenConfig = new StandardScreenConfig();
            } else if (string.equals("customScreen")) {
                baseScreenConfig = new CustomScreenConfig();
            }
            if (baseScreenConfig == null) continue;
            ((BaseScreenConfig)baseScreenConfig).read(xMLElement2);
            linkedList.add((StandardScreenConfig)baseScreenConfig);
        }
        this.screens = Collections.unmodifiableList(linkedList);
    }

    private void readUninstallDelete(XMLElement xMLElement) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = InstallerConfig.readAttribute(xMLElement2, "name", "");
            if (string.equals("")) continue;
            arrayList.add(string);
        }
        this.uninstallDeleteEntries = Collections.unmodifiableList(arrayList);
    }

    private void readMenu(XMLElement xMLElement) {
        LinkedList<MenuEntryConfig> linkedList = new LinkedList<MenuEntryConfig>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            MenuEntryConfig menuEntryConfig = new MenuEntryConfig();
            menuEntryConfig.read(xMLElement2);
            linkedList.add(menuEntryConfig);
        }
        this.menuEntries = Collections.unmodifiableList(linkedList);
    }

    private void readComponents(XMLElement xMLElement) {
        LinkedList<ComponentConfig> linkedList = new LinkedList<ComponentConfig>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            ComponentConfig componentConfig = new ComponentConfig();
            componentConfig.read(xMLElement2);
            linkedList.add(componentConfig);
        }
        this.components = Collections.unmodifiableList(linkedList);
    }

    private void readServices(XMLElement xMLElement) {
        LinkedList<ServiceConfig> linkedList = new LinkedList<ServiceConfig>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            ServiceConfig serviceConfig = new ServiceConfig();
            serviceConfig.read(xMLElement2);
            linkedList.add(serviceConfig);
        }
        this.services = Collections.unmodifiableList(linkedList);
    }

    private void readTasks(XMLElement xMLElement) {
        this.customTasksPlaceBefore = InstallerConfig.readAttribute(xMLElement, "customTasksPlacementBefore", this.customTasksPlaceBefore);
        LinkedList<CustomTaskConfig> linkedList = new LinkedList<CustomTaskConfig>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            CustomTaskConfig customTaskConfig = new CustomTaskConfig();
            customTaskConfig.read(xMLElement2);
            linkedList.add(customTaskConfig);
        }
        this.customTasks = Collections.unmodifiableList(linkedList);
    }

    private void readAssociations(XMLElement xMLElement) {
        LinkedList<AssociationConfig> linkedList = new LinkedList<AssociationConfig>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            AssociationConfig associationConfig = new AssociationConfig();
            associationConfig.read(xMLElement2);
            linkedList.add(associationConfig);
        }
        this.associations = Collections.unmodifiableList(linkedList);
    }

    public String getTargetApplicationId() {
        if (this.getInstallerType() == 1) {
            return this.getApplicationId();
        }
        return this.getAddonAppId();
    }
}

