/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jsr353;

import com.owlike.genson.ext.jsr353.JSR353Bundle;
import java.util.AbstractList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

class GensonJsonArray
extends AbstractList<JsonValue>
implements JsonArray {
    private final List<JsonValue> values;

    GensonJsonArray(List<JsonValue> values) {
        this.values = values;
    }

    public JsonObject getJsonObject(int index) {
        return (JsonObject)JsonObject.class.cast(this.values.get(index));
    }

    public JsonArray getJsonArray(int index) {
        return (JsonArray)JsonArray.class.cast(this.values.get(index));
    }

    public JsonNumber getJsonNumber(int index) {
        return (JsonNumber)JsonNumber.class.cast(this.values.get(index));
    }

    public JsonString getJsonString(int index) {
        return (JsonString)JsonString.class.cast(this.values.get(index));
    }

    public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
        return this.values;
    }

    public String getString(int index) {
        return this.getJsonString(index).getString();
    }

    public String getString(int index, String defaultValue) {
        if (this.isNull(index)) {
            return defaultValue;
        }
        return this.getString(index);
    }

    public int getInt(int index) {
        return this.getJsonNumber(index).intValue();
    }

    public int getInt(int index, int defaultValue) {
        if (this.isNull(index)) {
            return defaultValue;
        }
        return this.getInt(index);
    }

    public boolean getBoolean(int index) {
        JsonValue value = this.values.get(index);
        if (JsonValue.TRUE.equals(value)) {
            return true;
        }
        if (JsonValue.FALSE.equals(value)) {
            return false;
        }
        throw new ClassCastException();
    }

    public boolean getBoolean(int index, boolean defaultValue) {
        if (this.isNull(index)) {
            return defaultValue;
        }
        return this.getBoolean(index);
    }

    public boolean isNull(int index) {
        return JsonValue.NULL.equals(this.values.get(index));
    }

    @Override
    public JsonValue get(int index) {
        return this.values.get(index);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.values.equals(o);
    }

    @Override
    public String toString() {
        return JSR353Bundle.toString((JsonValue)this);
    }
}

