/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.out;

import java.util.Collection;
import java.util.Iterator;
import pl.mn.communicator.LocalUser;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.out.GGOutgoingPackage;

public class GGUserListRequest
implements GGOutgoingPackage {
    public static final int GG_USERLIST_REQUEST = 22;
    private static final byte GG_USER_LIST_PUT = 0;
    private static final int GG_USERLIST_GET = 2;
    private Collection m_usersToExport = null;
    private byte m_type;
    private String m_request;

    private GGUserListRequest() {
    }

    private String prepareRequest() {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.m_usersToExport.iterator();
        while (it.hasNext()) {
            LocalUser localUser = (LocalUser)it.next();
            if (localUser.getFirstName() != null) {
                buffer.append(localUser.getFirstName());
            }
            buffer.append(';');
            if (localUser.getLastName() != null) {
                buffer.append(localUser.getLastName());
            }
            buffer.append(';');
            if (localUser.getNickName() != null) {
                buffer.append(localUser.getNickName());
            }
            buffer.append(';');
            if (localUser.getDisplayName() != null) {
                buffer.append(localUser.getDisplayName());
            }
            buffer.append(';');
            if (localUser.getTelephone() != null) {
                buffer.append(localUser.getTelephone());
            }
            buffer.append(';');
            if (localUser.getGroup() != null) {
                buffer.append(localUser.getGroup());
            }
            buffer.append(';');
            if (localUser.getUin() != -1) {
                buffer.append(localUser.getUin());
            }
            buffer.append(';');
            if (localUser.getEmailAddress() != null) {
                buffer.append(localUser.getEmailAddress());
            }
            buffer.append(';');
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public int getPacketType() {
        return 22;
    }

    public int getLength() {
        return 1 + this.m_request.length();
    }

    public byte[] getContents() {
        byte[] toSend = new byte[this.getLength()];
        toSend[0] = this.m_type;
        byte[] bytes = GGUtils.stringToBytes(this.m_request);
        for (int i = 0; i < bytes.length; ++i) {
            toSend[1 + i] = bytes[i];
        }
        return toSend;
    }

    public static GGUserListRequest createClearUsetListRequest() {
        GGUserListRequest listRequest = new GGUserListRequest();
        listRequest.m_request = "";
        listRequest.m_type = 0;
        return listRequest;
    }

    public static GGUserListRequest createPutUserListRequest(Collection users) {
        if (users == null) {
            throw new NullPointerException("users collection cannot be null");
        }
        GGUserListRequest listRequest = new GGUserListRequest();
        listRequest.m_type = 0;
        listRequest.m_usersToExport = users;
        listRequest.m_request = listRequest.prepareRequest();
        return listRequest;
    }

    public static GGUserListRequest createGetUserListRequest() {
        GGUserListRequest listRequest = new GGUserListRequest();
        listRequest.m_type = (byte)2;
        listRequest.m_request = "";
        return listRequest;
    }
}

