/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.CommandRegister;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.commands.AbstractCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsonCommand
extends AbstractCommand {
    public static final String IDENTIFIER_PRIMARY = "ISON";
    public static final String IDENTIFIER_SECONDARY = "303";
    List<String> nicks = new ArrayList<String>();
    String dest = null;

    public IsonCommand() {
    }

    public IsonCommand(String nick) {
        this.nicks.add(nick);
    }

    public IsonCommand(String dest, String nick) {
        this.dest = dest;
        this.nicks.add(nick);
    }

    public IsonCommand(List<String> nicks) {
        this.nicks.addAll(nicks);
    }

    public IsonCommand(String dest, List<String> nicks) {
        this.dest = dest;
        this.nicks.addAll(nicks);
    }

    @Override
    public InCommand parse(String prefix, String identifier, String params) {
        if (identifier.equals(IDENTIFIER_SECONDARY)) {
            String nickParam = this.getParameter(params, 1);
            List<String> nicks = Arrays.asList(nickParam.split(" "));
            return new IsonCommand(this.getParameter(params, 0), nicks);
        }
        String nickParam = this.getParameter(params, 0);
        List<String> nicks = Arrays.asList(nickParam.split(" "));
        return new IsonCommand(nicks);
    }

    @Override
    public String renderParams() {
        String ret = "";
        if (this.nicks.size() > 0) {
            Boolean isFirst = true;
            for (String nick : this.nicks) {
                if (isFirst.booleanValue()) {
                    ret = ret + nick;
                    isFirst = false;
                    continue;
                }
                ret = ret + " " + nick;
            }
        }
        return ret;
    }

    @Override
    public String getIrcIdentifier() {
        return IDENTIFIER_PRIMARY;
    }

    @Override
    public void selfRegister(CommandRegister commandRegister) {
        commandRegister.addCommand(IDENTIFIER_PRIMARY, this);
        commandRegister.addCommand(IDENTIFIER_SECONDARY, this);
    }

    public String getDest() {
        return this.dest;
    }

    public List<String> getNicks() {
        return this.nicks;
    }
}

