/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import net.sf.jqql.Util;
import net.sf.jqql.net.AbstractProxy;
import net.sf.jqql.net.IProxyHandler;
import net.sf.jqql.packets.PacketParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Socks5Proxy
extends AbstractProxy {
    private static final Log log = LogFactory.getLog(Socks5Proxy.class);
    public static final byte VER_5 = 5;
    public static final byte AUTH_NONE = 0;
    public static final byte AUTH_USERNAME_PASSWORD = 2;
    public static final byte REQ_CONNECT = 1;
    public static final byte REQ_UDP_ASSOCIATE = 3;
    public static final byte ATYP_IPV4 = 1;
    public static final byte ATYP_DOMAIN_NAME = 3;
    public static final byte ATYP_IPV6 = 4;
    public static final byte REPLY_SUCCESS = 0;
    public static final int STATUS_NONE = 0;
    public static final int STATUS_INIT = 1;
    public static final int STATUS_AUTH = 2;
    public static final int STATUS_CONNECT = 3;
    public static final int STATUS_UDP_ASSOCIATE = 4;
    public static final int STATUS_READY = 5;
    protected byte[] remoteAddress;
    protected int remotePort;
    protected boolean isIp;
    protected boolean NeedVerify;

    public Socks5Proxy(IProxyHandler iProxyHandler, String string, String string2, DatagramChannel datagramChannel) throws IOException {
        super(iProxyHandler, datagramChannel);
        this.status = 0;
        this.NeedVerify = false;
        if (string != null) {
            this.NeedVerify = true;
            this.username = string;
        }
        if (string2 != null) {
            this.password = string2;
        }
    }

    public Socks5Proxy(IProxyHandler iProxyHandler, String string, String string2) throws IOException {
        super(iProxyHandler);
        this.status = 0;
        this.NeedVerify = false;
        if (string != null) {
            this.NeedVerify = true;
            this.username = string;
        }
        if (string2 != null) {
            this.password = string2;
        }
    }

    public void init() {
        log.trace((Object)"Socks5 init");
        this.buffer.clear();
        this.buffer.put((byte)5).put((byte)1).put(this.NeedVerify ? (byte)2 : 0);
        this.buffer.flip();
        this.send();
        this.status = 1;
    }

    protected void auth() {
        log.trace((Object)"Socks5 auth");
        this.buffer.clear();
        this.buffer.put((byte)5).put((byte)(this.username.length() & 0xFF)).put(this.username.getBytes()).put((byte)(this.password.length() & 0xFF)).put(this.password.getBytes());
        this.buffer.flip();
        this.send();
        this.status = 2;
    }

    protected void connect() {
        log.trace((Object)"Socks5 connect");
        this.buffer.clear();
        this.buffer.put((byte)5).put((byte)1).put((byte)0).put(this.isIp ? (byte)1 : 3).put(this.remoteAddress).putChar((char)this.remotePort);
        this.buffer.flip();
        this.send();
        this.status = 3;
    }

    protected void associate() {
        log.trace((Object)"Socks5 associate");
        this.buffer.clear();
        this.buffer.put((byte)5).put((byte)3).put((byte)0).put((byte)1).putInt(0).putChar((char)this.clientPort);
        this.buffer.flip();
        this.send();
        this.status = 4;
    }

    public void processRead(SelectionKey selectionKey) throws IOException, PacketParseException {
        this.receive();
        if (!this.buffer.hasRemaining()) {
            return;
        }
        if (this.buffer.get(0) != 5) {
            return;
        }
        switch (this.status) {
            case 1: {
                if (this.buffer.get(1) == 0) {
                    log.debug((Object)"\u4ee3\u7406\u670d\u52a1\u5668\u8fde\u63a5\u6210\u529f\uff0c\u4e0d\u9700\u8981\u8ba4\u8bc1");
                    if (this.udp) {
                        this.associate();
                        break;
                    }
                    this.connect();
                    break;
                }
                if (this.buffer.get(1) == 2) {
                    log.debug((Object)"\u4ee3\u7406\u670d\u52a1\u5668\u8fde\u63a5\u6210\u529f\uff0c\u9700\u8981\u8ba4\u8bc1");
                    this.auth();
                    break;
                }
                log.debug((Object)"\u4e0d\u652f\u6301\u7684\u9a8c\u8bc1\u65b9\u6cd5");
                this.handler.proxyAuthFail();
                break;
            }
            case 2: {
                if (this.buffer.get(1) == 0) {
                    log.debug((Object)"\u9a8c\u8bc1\u901a\u8fc7");
                    if (this.udp) {
                        this.associate();
                        break;
                    }
                    this.connect();
                    break;
                }
                log.debug((Object)"\u9a8c\u8bc1\u5931\u8d25");
                this.handler.proxyAuthFail();
                break;
            }
            case 3: {
                if (this.buffer.get(1) == 0) {
                    log.debug((Object)"CONNECT\u547d\u4ee4\u5b8c\u6210");
                    this.status = 5;
                    this.handler.proxyReady(null);
                    break;
                }
                log.debug((Object)"\u4ee3\u7406\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff0c\u4ee3\u7406\u4e0d\u53ef\u7528");
                this.handler.proxyError("\u4ee3\u7406\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff0c\u4ee3\u7406\u4e0d\u53ef\u7528");
                break;
            }
            case 4: {
                if (this.buffer.get(1) == 0) {
                    byte by = this.buffer.get(3);
                    byte[] byArray = new byte[this.buffer.limit() - 6];
                    this.buffer.position(4);
                    this.buffer.get(byArray);
                    char c = this.buffer.getChar();
                    String string = null;
                    if (by == 1) {
                        string = Util.getIpStringFromBytes(byArray);
                    } else if (by == 3) {
                        string = new String(byArray);
                    } else {
                        log.debug((Object)"\u4e0d\u652f\u6301IPV6");
                        return;
                    }
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(string, (int)c);
                    log.debug((Object)("UDP\u7ed1\u5b9a\u5df2\u5b8c\u6210\uff0cBND.ADDR: " + string + " BND.PORT: " + c));
                    this.status = 5;
                    selectionKey.cancel();
                    this.handler.proxyReady(inetSocketAddress);
                    break;
                }
                log.debug((Object)"\u4ee3\u7406\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff0c\u4ee3\u7406\u4e0d\u53ef\u7528");
                this.handler.proxyError("\u4ee3\u7406\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff0c\u4ee3\u7406\u4e0d\u53ef\u7528");
                break;
            }
        }
    }

    public void processWrite() throws IOException {
        log.trace((Object)"Socks5Proxy processWrite");
        if (this.connected && this.status == 0) {
            this.init();
        }
    }

    public void setRemoteAddress(InetSocketAddress inetSocketAddress) {
        super.setRemoteAddress(inetSocketAddress);
        if (inetSocketAddress.isUnresolved()) {
            this.isIp = false;
            byte[] byArray = inetSocketAddress.getHostName().getBytes();
            this.remoteAddress = new byte[byArray.length + 1];
            this.remoteAddress[0] = (byte)(byArray.length & 0xFF);
            System.arraycopy(byArray, 0, this.remoteAddress, 1, byArray.length);
        } else {
            this.isIp = true;
            this.remoteAddress = inetSocketAddress.getAddress().getAddress();
        }
        this.remotePort = inetSocketAddress.getPort();
    }

    public void setClientPort(int n) {
        this.clientPort = n;
    }
}

