/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.CustomScreen;
import com.install4j.api.InstallerEvent;
import com.install4j.api.InstallerEventListener;
import com.install4j.api.InstallerWizardContext;
import com.install4j.api.ProgressInterface;
import com.install4j.runtime.installer.InstallerContextImpl;
import com.install4j.runtime.installer.frontend.InstallerScreen;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class InstallerWizardContextImpl
extends InstallerContextImpl
implements InstallerWizardContext {
    private HashSet listeners = new HashSet();
    private List customScreens;

    InstallerWizardContextImpl(InstallerWizard installerWizard, ProgressInterface progressInterface) {
        super(installerWizard, progressInterface);
    }

    public void addInstallerEventListener(InstallerEventListener installerEventListener) {
        this.listeners.add(installerEventListener);
    }

    public void removeInstallerEventListener(InstallerEventListener installerEventListener) {
        this.listeners.remove(installerEventListener);
    }

    public List getCustomScreens() {
        if (this.customScreens == null) {
            this.customScreens = Collections.unmodifiableList(this.wizard.getCustomScreens());
        }
        return this.customScreens;
    }

    public CustomScreen getCustomScreenOfClass(Class clazz) {
        Iterator iterator = this.getCustomScreens().iterator();
        while (iterator.hasNext()) {
            CustomScreen customScreen = (CustomScreen)iterator.next();
            if (customScreen.getClass() != clazz) continue;
            return customScreen;
        }
        return null;
    }

    public boolean gotoStandardScreen(String string) {
        return this.wizard.activateStandardScreen(string);
    }

    public boolean gotoCustomScreen(CustomScreen customScreen) {
        return this.wizard.activateCustomScreen(customScreen);
    }

    public void setNextButtonEnabled(boolean bl) {
        InstallerScreen installerScreen = this.wizard.getCurrentScreen();
        if (installerScreen != null) {
            installerScreen.setNextButtonEnabled(bl);
        }
    }

    public void setBackButtonEnabled(boolean bl) {
        InstallerScreen installerScreen = this.wizard.getCurrentScreen();
        if (installerScreen != null) {
            installerScreen.setPreviousButtonEnabled(bl);
        }
    }

    public void setCancelButtonEnabled(boolean bl) {
        InstallerScreen installerScreen = this.wizard.getCurrentScreen();
        if (installerScreen != null) {
            installerScreen.setCancelButtonEnabled(bl);
        }
    }

    void fireInstallerEvent(InstallerEvent installerEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            InstallerEventListener installerEventListener = (InstallerEventListener)iterator.next();
            installerEventListener.installerEvent(installerEvent);
        }
    }

    public void setContextForCustomScreens() {
        Iterator iterator = this.getCustomScreens().iterator();
        while (iterator.hasNext()) {
            CustomScreen customScreen = (CustomScreen)iterator.next();
            customScreen.setInstallerContext(this);
            this.addInstallerEventListener(customScreen);
        }
    }
}

