/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import org.eclipse.jetty.io.bio.StreamEndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SocketEndPoint
extends StreamEndPoint {
    private static final Logger LOG = Log.getLogger(SocketEndPoint.class);
    final Socket _socket;
    final InetSocketAddress _local;
    final InetSocketAddress _remote;

    public SocketEndPoint(Socket socket) throws IOException {
        super(socket.getInputStream(), socket.getOutputStream());
        this._socket = socket;
        this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        super.setMaxIdleTime(this._socket.getSoTimeout());
    }

    protected SocketEndPoint(Socket socket, int maxIdleTime) throws IOException {
        super(socket.getInputStream(), socket.getOutputStream());
        this._socket = socket;
        this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        this._socket.setSoTimeout(maxIdleTime > 0 ? maxIdleTime : 0);
        super.setMaxIdleTime(maxIdleTime);
    }

    public boolean isOpen() {
        return super.isOpen() && this._socket != null && !this._socket.isClosed();
    }

    public boolean isInputShutdown() {
        return !this.isOpen() || super.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return !this.isOpen() || super.isOutputShutdown();
    }

    public void shutdownOutput() throws IOException {
        if (!this.isOutputShutdown()) {
            super.shutdownOutput();
            if (!(this._socket instanceof SSLSocket)) {
                this._socket.shutdownOutput();
            }
        }
    }

    public void shutdownInput() throws IOException {
        if (!this.isInputShutdown()) {
            super.shutdownInput();
            if (!(this._socket instanceof SSLSocket)) {
                this._socket.shutdownInput();
            }
        }
    }

    public void close() throws IOException {
        this._socket.close();
        this._in = null;
        this._out = null;
    }

    public String getLocalAddr() {
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getHostAddress();
    }

    public String getLocalHost() {
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getCanonicalHostName();
    }

    public int getLocalPort() {
        if (this._local == null) {
            return -1;
        }
        return this._local.getPort();
    }

    public String getRemoteAddr() {
        if (this._remote == null) {
            return null;
        }
        InetAddress addr = this._remote.getAddress();
        return addr == null ? null : addr.getHostAddress();
    }

    public String getRemoteHost() {
        if (this._remote == null) {
            return null;
        }
        return this._remote.getAddress().getCanonicalHostName();
    }

    public int getRemotePort() {
        if (this._remote == null) {
            return -1;
        }
        return this._remote.getPort();
    }

    public Object getTransport() {
        return this._socket;
    }

    public void setMaxIdleTime(int timeMs) throws IOException {
        if (timeMs != this.getMaxIdleTime()) {
            this._socket.setSoTimeout(timeMs > 0 ? timeMs : 0);
        }
        super.setMaxIdleTime(timeMs);
    }

    protected void idleExpired() throws IOException {
        try {
            if (!this.isInputShutdown()) {
                this.shutdownInput();
            }
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
            this._socket.close();
        }
    }
}

