/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.log;

import java.lang.reflect.Method;
import org.mortbay.log.Logger;
import org.mortbay.log.StdErrLog;
import org.mortbay.util.Loader;

public class Log {
    private static final String[] __nestedEx;
    private static final Class[] __noArgs;
    public static final String EXCEPTION = "EXCEPTION ";
    public static final String IGNORED = "IGNORED";
    public static final String IGNORED_FMT = "IGNORED: {}";
    public static final String NOT_IMPLEMENTED = "NOT IMPLEMENTED ";
    private static String logClass;
    private static boolean verbose;
    private static Logger log;

    public static void setLog(Logger log) {
        Log.log = log;
    }

    public static Logger getLog() {
        return log;
    }

    public static void debug(Throwable th) {
        if (log == null) {
            return;
        }
        log.debug(EXCEPTION, th);
        Log.unwind(th);
    }

    public static void debug(String msg) {
        if (log == null) {
            return;
        }
        log.debug(msg, null, null);
    }

    public static void debug(String msg, Object arg) {
        if (log == null) {
            return;
        }
        log.debug(msg, arg, null);
    }

    public static void debug(String msg, Object arg0, Object arg1) {
        if (log == null) {
            return;
        }
        log.debug(msg, arg0, arg1);
    }

    public static void ignore(Throwable th) {
        if (log == null) {
            return;
        }
        if (verbose) {
            log.debug(IGNORED, th);
            Log.unwind(th);
        }
    }

    public static void info(String msg) {
        if (log == null) {
            return;
        }
        log.info(msg, null, null);
    }

    public static void info(String msg, Object arg) {
        if (log == null) {
            return;
        }
        log.info(msg, arg, null);
    }

    public static void info(String msg, Object arg0, Object arg1) {
        if (log == null) {
            return;
        }
        log.info(msg, arg0, arg1);
    }

    public static boolean isDebugEnabled() {
        if (log == null) {
            return false;
        }
        return log.isDebugEnabled();
    }

    public static void warn(String msg) {
        if (log == null) {
            return;
        }
        log.warn(msg, null, null);
    }

    public static void warn(String msg, Object arg) {
        if (log == null) {
            return;
        }
        log.warn(msg, arg, null);
    }

    public static void warn(String msg, Object arg0, Object arg1) {
        if (log == null) {
            return;
        }
        log.warn(msg, arg0, arg1);
    }

    public static void warn(String msg, Throwable th) {
        if (log == null) {
            return;
        }
        log.warn(msg, th);
        Log.unwind(th);
    }

    public static void warn(Throwable th) {
        if (log == null) {
            return;
        }
        log.warn(EXCEPTION, th);
        Log.unwind(th);
    }

    public static Logger getLogger(String name) {
        if (log == null) {
            return log;
        }
        if (name == null) {
            return log;
        }
        return log.getLogger(name);
    }

    private static void unwind(Throwable th) {
        if (th == null) {
            return;
        }
        for (int i = 0; i < __nestedEx.length; ++i) {
            try {
                Method get_target = th.getClass().getMethod(__nestedEx[i], __noArgs);
                Throwable th2 = (Throwable)get_target.invoke((Object)th, (Object[])null);
                if (th2 == null || th2 == th) continue;
                Log.warn("Nested in " + th + ":", th2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        Class log_class;
        block2: {
            __nestedEx = new String[]{"getTargetException", "getTargetError", "getException", "getRootCause"};
            __noArgs = new Class[0];
            logClass = System.getProperty("org.mortbay.log.class", "org.mortbay.log.Slf4jLog");
            verbose = System.getProperty("VERBOSE", null) != null;
            log_class = null;
            try {
                log_class = Loader.loadClass(Log.class, logClass);
                log = (Logger)log_class.newInstance();
            }
            catch (Exception e) {
                log_class = StdErrLog.class;
                log = new StdErrLog();
                if (!verbose) break block2;
                e.printStackTrace();
            }
        }
        log.info("Logging to {} via {}", log, log_class.getName());
    }
}

