/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.permission;

import com.hazelcast.security.permission.AtomicLongPermission;
import com.hazelcast.security.permission.CountDownLatchPermission;
import com.hazelcast.security.permission.ExecutorServicePermission;
import com.hazelcast.security.permission.ListPermission;
import com.hazelcast.security.permission.LockPermission;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.security.permission.SemaphorePermission;
import com.hazelcast.security.permission.SetPermission;
import com.hazelcast.security.permission.TopicPermission;
import java.security.Permission;

public final class ActionConstants {
    public static final String ACTION_ALL = "all";
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_DESTROY = "destroy";
    public static final String ACTION_MODIFY = "modify";
    public static final String ACTION_READ = "read";
    public static final String ACTION_REMOVE = "remove";
    public static final String ACTION_LOCK = "lock";
    public static final String ACTION_LISTEN = "listen";
    public static final String ACTION_RELEASE = "release";
    public static final String ACTION_ACQUIRE = "acquire";
    public static final String ACTION_PUT = "put";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_INDEX = "index";
    public static final String ACTION_INTERCEPT = "intercept";
    public static final String ACTION_PUBLISH = "publish";
    public static final String LISTENER_INSTANCE = "instance";
    public static final String LISTENER_MEMBER = "member";
    public static final String LISTENER_MIGRATION = "migration";

    public static Permission getPermission(String name, String serviceName, String ... actions) {
        if ("hz:impl:queueService".equals(serviceName)) {
            return new QueuePermission(name, actions);
        }
        if ("hz:impl:mapService".equals(serviceName)) {
            return new MapPermission(name, actions);
        }
        if ("hz:impl:multiMapService".equals(serviceName)) {
            return new MultiMapPermission(name, actions);
        }
        if ("hz:impl:listService".equals(serviceName)) {
            return new ListPermission(name, actions);
        }
        if ("hz:impl:setService".equals(serviceName)) {
            return new SetPermission(name, actions);
        }
        if ("hz:impl:atomicLongService".equals(serviceName)) {
            return new AtomicLongPermission(name, actions);
        }
        if ("hz:impl:countDownLatchService".equals(serviceName)) {
            return new CountDownLatchPermission(name, actions);
        }
        if ("hz:impl:semaphoreService".equals(serviceName)) {
            return new SemaphorePermission(name, actions);
        }
        if ("hz:impl:topicService".equals(serviceName)) {
            return new TopicPermission(name, actions);
        }
        if ("hz:impl:lockService".equals(serviceName)) {
            return new LockPermission(name, actions);
        }
        if ("hz:impl:executorService".equals(serviceName)) {
            return new ExecutorServicePermission(name, actions);
        }
        if ("hz:impl:idGeneratorService".equals(serviceName)) {
            return new AtomicLongPermission("hz:atomic:idGenerator:" + name, actions);
        }
        throw new IllegalArgumentException("No service matched!!!");
    }
}

