/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.AwaitOperation;
import com.hazelcast.concurrent.lock.ConditionInfo;
import com.hazelcast.concurrent.lock.ConditionKey;
import com.hazelcast.concurrent.lock.LockResource;
import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

final class LockResourceImpl
implements DataSerializable,
LockResource {
    private Data key;
    private String owner = null;
    private int threadId = -1;
    private int lockCount;
    private long expirationTime = -1L;
    private long acquireTime = -1L;
    private boolean transactional = false;
    private Map<String, ConditionInfo> conditions;
    private List<ConditionKey> signalKeys;
    private List<AwaitOperation> expiredAwaitOps;
    private transient LockStoreImpl lockStore;

    public LockResourceImpl() {
    }

    public LockResourceImpl(Data key, LockStoreImpl lockStore) {
        this.key = key;
        this.lockStore = lockStore;
    }

    @Override
    public Data getKey() {
        return this.key;
    }

    @Override
    public boolean isLocked() {
        return this.lockCount > 0;
    }

    @Override
    public boolean isLockedBy(String owner, int threadId) {
        return this.threadId == threadId && owner != null && owner.equals(this.owner);
    }

    boolean lock(String owner, int threadId, long leaseTime) {
        return this.lock(owner, threadId, leaseTime, false);
    }

    boolean lock(String owner, int threadId, long leaseTime, boolean transactional) {
        if (this.lockCount == 0) {
            this.owner = owner;
            this.threadId = threadId;
            ++this.lockCount;
            this.acquireTime = Clock.currentTimeMillis();
            this.setExpirationTime(leaseTime);
            this.transactional = transactional;
            return true;
        }
        if (this.isLockedBy(owner, threadId)) {
            ++this.lockCount;
            this.setExpirationTime(leaseTime);
            this.transactional = transactional;
            return true;
        }
        this.transactional = false;
        return false;
    }

    boolean extendLeaseTime(String caller, int threadId, long leaseTime) {
        if (this.isLockedBy(caller, threadId)) {
            if (this.expirationTime < Long.MAX_VALUE) {
                this.setExpirationTime(this.expirationTime - Clock.currentTimeMillis() + leaseTime);
                this.lockStore.scheduleEviction(this.key, leaseTime);
            }
            return true;
        }
        return false;
    }

    private void setExpirationTime(long leaseTime) {
        if (leaseTime < 0L) {
            this.expirationTime = Long.MAX_VALUE;
        } else {
            this.expirationTime = Clock.currentTimeMillis() + leaseTime;
            if (this.expirationTime < 0L) {
                this.expirationTime = Long.MAX_VALUE;
            } else {
                this.lockStore.scheduleEviction(this.key, leaseTime);
            }
        }
    }

    boolean unlock(String owner, int threadId) {
        if (this.lockCount == 0) {
            return false;
        }
        if (this.isLockedBy(owner, threadId)) {
            --this.lockCount;
            if (this.lockCount == 0) {
                this.clear();
            }
            return true;
        }
        return false;
    }

    boolean canAcquireLock(String caller, int threadId) {
        return this.lockCount == 0 || this.getThreadId() == threadId && this.getOwner().equals(caller);
    }

    boolean addAwait(String conditionId, String caller, int threadId) {
        ConditionInfo condition;
        if (this.conditions == null) {
            this.conditions = new HashMap<String, ConditionInfo>(2);
        }
        if ((condition = this.conditions.get(conditionId)) == null) {
            condition = new ConditionInfo(conditionId);
            this.conditions.put(conditionId, condition);
        }
        return condition.addWaiter(caller, threadId);
    }

    boolean removeAwait(String conditionId, String caller, int threadId) {
        ConditionInfo condition;
        if (this.conditions != null && (condition = this.conditions.get(conditionId)) != null) {
            boolean ok = condition.removeWaiter(caller, threadId);
            if (condition.getAwaitCount() == 0) {
                this.conditions.remove(conditionId);
            }
            return ok;
        }
        return false;
    }

    boolean startAwaiting(String conditionId, String caller, int threadId) {
        ConditionInfo condition;
        if (this.conditions != null && (condition = this.conditions.get(conditionId)) != null) {
            return condition.startWaiter(caller, threadId);
        }
        return false;
    }

    int getAwaitCount(String conditionId) {
        if (this.conditions != null) {
            ConditionInfo condition = this.conditions.get(conditionId);
            return condition != null ? condition.getAwaitCount() : 0;
        }
        return 0;
    }

    void registerSignalKey(ConditionKey conditionKey) {
        if (this.signalKeys == null) {
            this.signalKeys = new LinkedList<ConditionKey>();
        }
        this.signalKeys.add(conditionKey);
    }

    ConditionKey getSignalKey() {
        List<ConditionKey> keys = this.signalKeys;
        return keys != null && !keys.isEmpty() ? keys.iterator().next() : null;
    }

    void removeSignalKey(ConditionKey conditionKey) {
        if (this.signalKeys != null) {
            this.signalKeys.remove(conditionKey);
        }
    }

    void registerExpiredAwaitOp(AwaitOperation awaitResponse) {
        if (this.expiredAwaitOps == null) {
            this.expiredAwaitOps = new LinkedList<AwaitOperation>();
        }
        this.expiredAwaitOps.add(awaitResponse);
    }

    AwaitOperation pollExpiredAwaitOp() {
        List<AwaitOperation> ops = this.expiredAwaitOps;
        if (ops != null && !ops.isEmpty()) {
            Iterator<AwaitOperation> iter = ops.iterator();
            AwaitOperation awaitResponse = iter.next();
            iter.remove();
            return awaitResponse;
        }
        return null;
    }

    void clear() {
        this.threadId = -1;
        this.lockCount = 0;
        this.owner = null;
        this.expirationTime = 0L;
        this.acquireTime = -1L;
        this.cancelEviction();
    }

    void cancelEviction() {
        this.lockStore.cancelEviction(this.key);
    }

    boolean isRemovable() {
        return !(this.isLocked() || this.conditions != null && !this.conditions.isEmpty() || this.expiredAwaitOps != null && !this.expiredAwaitOps.isEmpty());
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public boolean isTransactional() {
        return this.transactional;
    }

    @Override
    public int getThreadId() {
        return this.threadId;
    }

    @Override
    public int getLockCount() {
        return this.lockCount;
    }

    @Override
    public long getAcquireTime() {
        return this.acquireTime;
    }

    @Override
    public long getRemainingLeaseTime() {
        long now = Clock.currentTimeMillis();
        if (now >= this.expirationTime) {
            return 0L;
        }
        return this.expirationTime - now;
    }

    void setLockStore(LockStoreImpl lockStore) {
        this.lockStore = lockStore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockResourceImpl that = (LockResourceImpl)o;
        if (this.threadId != that.threadId) {
            return false;
        }
        return !(this.owner != null ? !this.owner.equals(that.owner) : that.owner != null);
    }

    public int hashCode() {
        int result = this.owner != null ? this.owner.hashCode() : 0;
        result = 31 * result + this.threadId;
        return result;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.key.writeData(out);
        out.writeUTF(this.owner);
        out.writeInt(this.threadId);
        out.writeInt(this.lockCount);
        out.writeLong(this.expirationTime);
        out.writeLong(this.acquireTime);
        out.writeBoolean(this.transactional);
        int len = this.conditions == null ? 0 : this.conditions.size();
        out.writeInt(len);
        if (len > 0) {
            for (ConditionInfo condition : this.conditions.values()) {
                condition.writeData(out);
            }
        }
        len = this.signalKeys == null ? 0 : this.signalKeys.size();
        out.writeInt(len);
        if (len > 0) {
            for (ConditionKey key : this.signalKeys) {
                out.writeUTF(key.getObjectName());
                out.writeUTF(key.getConditionId());
            }
        }
        len = this.expiredAwaitOps == null ? 0 : this.expiredAwaitOps.size();
        out.writeInt(len);
        if (len > 0) {
            for (AwaitOperation op : this.expiredAwaitOps) {
                op.writeData(out);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int i;
        this.key = new Data();
        this.key.readData(in);
        this.owner = in.readUTF();
        this.threadId = in.readInt();
        this.lockCount = in.readInt();
        this.expirationTime = in.readLong();
        this.acquireTime = in.readLong();
        this.transactional = in.readBoolean();
        int len = in.readInt();
        if (len > 0) {
            this.conditions = new HashMap<String, ConditionInfo>(len);
            for (i = 0; i < len; ++i) {
                ConditionInfo condition = new ConditionInfo();
                condition.readData(in);
                this.conditions.put(condition.getConditionId(), condition);
            }
        }
        if ((len = in.readInt()) > 0) {
            this.signalKeys = new ArrayList<ConditionKey>(len);
            for (i = 0; i < len; ++i) {
                this.signalKeys.add(new ConditionKey(in.readUTF(), this.key, in.readUTF()));
            }
        }
        if ((len = in.readInt()) > 0) {
            this.expiredAwaitOps = new ArrayList<AwaitOperation>(len);
            for (i = 0; i < len; ++i) {
                AwaitOperation op = new AwaitOperation();
                op.readData(in);
                this.expiredAwaitOps.add(op);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LockResource");
        sb.append("{owner='").append(this.owner).append('\'');
        sb.append(", threadId=").append(this.threadId);
        sb.append(", lockCount=").append(this.lockCount);
        sb.append(", acquireTime=").append(this.acquireTime);
        sb.append(", expirationTime=").append(this.expirationTime);
        sb.append('}');
        return sb.toString();
    }
}

