/*
 * Decompiled with CFR 0.152.
 */
package test_util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import socks.InetRange;
import socks.Proxy;
import socks.SocksException;
import socks.SocksSocket;

public class SocksTest
implements Runnable {
    private int port;
    private InetAddress hostIP;
    private Socket ss;
    private InputStream in;
    private OutputStream out;
    private static final int BUF_SIZE = 1024;
    static final int defaultProxyPort = 1080;
    static final String defaultProxyHost = "www-proxy";

    public SocksTest(String host, int port) throws IOException, UnknownHostException, SocksException {
        this.port = port;
        this.ss = new SocksSocket(host, port);
        this.out = this.ss.getOutputStream();
        this.in = this.ss.getInputStream();
        System.out.println("Connected...");
        System.out.println("TO: " + host + ":" + port);
        System.out.println("ViaProxy: " + this.ss.getLocalAddress().getHostAddress() + ":" + this.ss.getLocalPort());
    }

    public void close() throws IOException {
        this.ss.close();
    }

    public void send(String s) throws IOException {
        this.out.write(s.getBytes());
    }

    public void run() {
        byte[] buf = new byte[1024];
        try {
            int bytes_read;
            while ((bytes_read = this.in.read(buf)) > 0) {
                System.out.write(buf, 0, bytes_read);
            }
        }
        catch (IOException io_ex) {
            io_ex.printStackTrace();
        }
    }

    public static void usage() {
        System.err.print("Usage: java SocksTest host port [socksHost socksPort]\n");
    }

    public static void main(String[] args) {
        if (args.length > 1 && args.length < 5) {
            try {
                String host = args[0];
                int port = Integer.parseInt(args[1]);
                int proxyPort = args.length > 3 ? Integer.parseInt(args[3]) : 1080;
                host = args[0];
                String proxyHost = args.length > 2 ? args[2] : defaultProxyHost;
                Proxy.setDefaultProxy(proxyHost, proxyPort, "KOUKY001");
                InetRange range = new InetRange();
                range.add(InetAddress.getByName("localhost"));
                Proxy.getDefaultProxy().setDirect(range);
                SocksTest st = new SocksTest(host, port);
                Thread thread = new Thread(st);
                thread.start();
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                String s = in.readLine();
                while (s != null) {
                    st.send(s + "\r\n");
                    s = in.readLine();
                }
                st.close();
                System.exit(1);
            }
            catch (SocksException s_ex) {
                System.err.println("SocksException:" + s_ex);
                s_ex.printStackTrace();
                System.exit(1);
            }
            catch (IOException io_ex) {
                io_ex.printStackTrace();
                System.exit(1);
            }
            catch (NumberFormatException num_ex) {
                SocksTest.usage();
                num_ex.printStackTrace();
                System.exit(1);
            }
        } else {
            SocksTest.usage();
        }
    }
}

