/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.in._08;

import java.nio.ByteBuffer;
import net.sf.jqql.Util;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08BasicInPacket;

public class _08LoginReplyPacket
extends _08BasicInPacket {
    public byte replyCode;
    public byte[] sessionKey;
    public byte[] ip;
    public char port;
    public byte[] serverIp;
    public char serverPort;
    public long loginTime;
    public byte[] loginTimeRude;
    public long lastLoginTime;
    public String replyMessage;
    public byte[] clientKey;
    public byte[] lastLoginIp;
    public byte[] redirectIp;
    public int redirectPort;
    public byte[] localHost;
    public byte[] authToken;
    public byte[] userQQ;

    public _08LoginReplyPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public String getPacketName() {
        return "07 Login Reply _08Packet";
    }

    public byte[] getDecryptKey(byte[] byArray) {
        return this.user.getPasswordKey();
    }

    public byte[] getFallbackDecryptKey(byte[] byArray) {
        return this.user.getLoginKey();
    }

    protected void parseBody(ByteBuffer byteBuffer) throws PacketParseException {
        this.replyCode = byteBuffer.get();
        switch (this.replyCode) {
            case 0: {
                this.sessionKey = new byte[16];
                byteBuffer.get(this.sessionKey);
                this.userQQ = new byte[4];
                byteBuffer.get(this.userQQ);
                this.ip = new byte[4];
                byteBuffer.get(this.ip);
                this.port = byteBuffer.getChar();
                this.localHost = new byte[4];
                byteBuffer.get(this.localHost);
                this.serverPort = byteBuffer.getChar();
                this.loginTimeRude = new byte[4];
                byteBuffer.get(this.loginTimeRude);
                this.loginTime = (long)Util.getIntFromBytes(this.loginTimeRude, 0, 4) * 1000L;
                byteBuffer.position(byteBuffer.position() + 50);
                this.clientKey = new byte[32];
                byteBuffer.get(this.clientKey);
                byteBuffer.position(byteBuffer.position() + 12);
                this.lastLoginIp = new byte[4];
                byteBuffer.get(this.lastLoginIp);
                this.lastLoginTime = (long)byteBuffer.getInt() * 1000L;
                break;
            }
            case 9: {
                byte[] byArray = byteBuffer.array();
                this.replyMessage = Util.getString(byArray, 1, byArray.length - 1, "GBK");
                break;
            }
            case 10: {
                byteBuffer.getInt();
                byteBuffer.position(byteBuffer.position() + 10);
                this.redirectIp = new byte[4];
                byteBuffer.get(this.redirectIp);
                this.redirectPort = this.user.getPort();
                break;
            }
            case 5: {
                log.debug((Object)"\u767b\u5f55\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u4e0a\u7ebf\u9ad8\u5cf0\u5427\uff0c\u7ba1\u4ed6\u5462\uff0c\u7ee7\u7eed\u767b\u5f55\uff01");
            }
        }
    }
}

