/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql;

import net.sf.jqql.QQClient;
import net.sf.jqql.Util;
import net.sf.jqql.events.IPacketListener;
import net.sf.jqql.events.PacketEvent;
import net.sf.jqql.events.QQEvent;
import net.sf.jqql.packets.ErrorPacket;
import net.sf.jqql.packets._05InPacket;
import net.sf.jqql.packets._08InPacket;
import net.sf.jqql.packets._08OutPacket;
import net.sf.jqql.packets.in._05.RequestAgentReplyPacket;
import net.sf.jqql.packets.in._05.Unknown05InPacket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class _05FamilyProcessor
implements IPacketListener {
    static Log log = LogFactory.getLog(_05FamilyProcessor.class);
    private QQClient client;

    public _05FamilyProcessor(QQClient qQClient) {
        this.client = qQClient;
    }

    public void packetArrived(PacketEvent packetEvent) {
        if (packetEvent.getSource() instanceof ErrorPacket) {
            this.processError((ErrorPacket)packetEvent.getSource());
            return;
        }
        _05InPacket _05InPacket2 = (_05InPacket)packetEvent.getSource();
        if (_05InPacket2 instanceof Unknown05InPacket) {
            log.debug((Object)"\u6536\u5230\u4e00\u4e2a\u672a\u77e5\u683c\u5f0f\u5305");
            return;
        }
        this.client.removeResendPacket(_05InPacket2);
        log.debug((Object)("\u5305" + _05InPacket2.getSequence() + "\u7684\u786e\u8ba4\u5df2\u7ecf\u6536\u5230\uff0c\u5c06\u4e0d\u518d\u53d1\u9001"));
        switch (_05InPacket2.getCommand()) {
            case '!': {
                this.processRequestAgentReply(_05InPacket2);
                break;
            }
            case '\"': {
                this.processRequestFaceReply(_05InPacket2);
                break;
            }
            case '&': {
                this.processRequestBeginReply(_05InPacket2);
                break;
            }
            case '#': {
                this.processTransferReply(_05InPacket2);
            }
        }
    }

    private void processError(ErrorPacket errorPacket) {
        QQEvent qQEvent = null;
        switch (errorPacket.errorCode) {
            case 1: {
                _08OutPacket _08OutPacket2 = errorPacket.timeoutPacket;
                qQEvent = new QQEvent(_08OutPacket2);
                qQEvent.type = 28683;
                qQEvent.operation = _08OutPacket2.getCommand();
                break;
            }
            case 2: {
                qQEvent = new QQEvent(errorPacket);
                qQEvent.type = 4098;
                break;
            }
            case 3: {
                qQEvent = new QQEvent(errorPacket);
                qQEvent.type = 4097;
            }
        }
        if (qQEvent != null) {
            this.client.fireQQEvent(qQEvent);
        }
    }

    private void processRequestFaceReply(_05InPacket _05InPacket2) {
        QQEvent qQEvent = new QQEvent(_05InPacket2);
        qQEvent.type = 8202;
        this.client.fireQQEvent(qQEvent);
    }

    private void processTransferReply(_05InPacket _05InPacket2) {
        if (_05InPacket2.getSource() == '\u115b') {
            QQEvent qQEvent = new QQEvent(_05InPacket2);
            qQEvent.type = 8206;
            this.client.fireQQEvent(qQEvent);
        } else if (_05InPacket2.getSequence() == '\u0000') {
            QQEvent qQEvent = new QQEvent(_05InPacket2);
            qQEvent.type = 8195;
            this.client.fireQQEvent(qQEvent);
        } else {
            QQEvent qQEvent = new QQEvent(_05InPacket2);
            qQEvent.type = 8194;
            this.client.fireQQEvent(qQEvent);
        }
    }

    private void processRequestBeginReply(_05InPacket _05InPacket2) {
        log.debug((Object)"\u670d\u52a1\u5668\u540c\u610f\u5f00\u59cb\u53d1\u9001");
        QQEvent qQEvent = new QQEvent(_05InPacket2);
        qQEvent.type = 8201;
        this.client.fireQQEvent(qQEvent);
    }

    private void processRequestAgentReply(_05InPacket _05InPacket2) {
        RequestAgentReplyPacket requestAgentReplyPacket = (RequestAgentReplyPacket)_05InPacket2;
        switch (requestAgentReplyPacket.replyCode) {
            case '\u0001': {
                log.debug((Object)("\u8bf7\u6c42\u4e2d\u8f6c\u670d\u52a1\u5668\u91cd\u5b9a\u5411\uff0c to " + Util.convertIpToString(requestAgentReplyPacket.redirectIp)));
                QQEvent qQEvent = new QQEvent(requestAgentReplyPacket);
                qQEvent.type = 8200;
                this.client.fireQQEvent(qQEvent);
                break;
            }
            case '\u0000': {
                log.debug((Object)"\u8bf7\u6c42\u4e2d\u8f6c\u670d\u52a1\u5668\u6210\u529f");
                QQEvent qQEvent = new QQEvent(requestAgentReplyPacket);
                qQEvent.type = 8199;
                this.client.fireQQEvent(qQEvent);
                break;
            }
            case '\u0003': {
                log.debug((Object)requestAgentReplyPacket.message);
                QQEvent qQEvent = new QQEvent(requestAgentReplyPacket);
                qQEvent.type = 8198;
                this.client.fireQQEvent(qQEvent);
                break;
            }
            default: {
                log.debug((Object)("\u672a\u77e5\u7684Request Agent\u56de\u590d\u7801: " + requestAgentReplyPacket.replyCode));
            }
        }
    }

    public boolean accept(_08InPacket _08InPacket2) {
        return (_08InPacket2.getFamily() & 2) != 0;
    }
}

