/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.RateClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateInfoCmd
extends ConnCommand {
    private final List<RateClassInfo> infos;

    protected RateInfoCmd(SnacPacket packet) {
        super(7);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        int rates = BinaryTools.getUShort((ByteBlock)snacData, (int)0);
        ArrayList<RateClassInfo> infos = new ArrayList<RateClassInfo>(rates);
        ByteBlock block = snacData.subBlock(2);
        for (int i = 0; i < rates; ++i) {
            RateClassInfo info = RateClassInfo.readRateClassInfo(block);
            infos.add(info);
            block = block.subBlock((int)info.getWritableLength());
        }
        Iterator rit = infos.iterator();
        for (int ri = 0; ri < rates; ++ri) {
            assert (rit.hasNext());
            int rclass = BinaryTools.getUShort((ByteBlock)block, (int)0);
            int familyCount = BinaryTools.getUShort((ByteBlock)block, (int)2);
            ArrayList<CmdType> cmds = new ArrayList<CmdType>(familyCount);
            RateClassInfo info = (RateClassInfo)rit.next();
            if (rclass != info.getRateClass()) continue;
            for (int fi = 0; fi < familyCount; ++fi) {
                int family = BinaryTools.getUShort((ByteBlock)block, (int)(4 + fi * 4));
                int command = BinaryTools.getUShort((ByteBlock)block, (int)(4 + fi * 4 + 2));
                cmds.add(new CmdType(family, command));
            }
            info.setCommands(cmds);
            block = block.subBlock(4 + familyCount * 4);
        }
        this.infos = infos;
    }

    public RateInfoCmd(Collection<RateClassInfo> infos) {
        super(7);
        this.infos = DefensiveTools.getSafeListCopy(infos, (String)"infos");
    }

    public List<RateClassInfo> getRateClassInfos() {
        return this.infos;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        int len = this.infos == null ? 0 : this.infos.size();
        BinaryTools.writeUShort((OutputStream)out, (int)len);
        if (this.infos != null) {
            for (RateClassInfo info : this.infos) {
                info.write(out);
            }
            for (RateClassInfo info1 : this.infos) {
                BinaryTools.writeUShort((OutputStream)out, (int)info1.getRateClass());
                if (info1.getCommands() == null) {
                    BinaryTools.writeUShort((OutputStream)out, (int)0);
                    continue;
                }
                BinaryTools.writeUShort((OutputStream)out, (int)info1.getCommands().size());
                for (CmdType family1 : info1.getCommands()) {
                    BinaryTools.writeUShort((OutputStream)out, (int)family1.getFamily());
                    BinaryTools.writeUShort((OutputStream)out, (int)family1.getCommand());
                }
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RateInfoCmd: ");
        for (RateClassInfo info : this.infos) {
            buffer.append(info);
            buffer.append(" - ");
        }
        return buffer.toString();
    }
}

