/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.Serializer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public final class ThreadContext {
    private static final AtomicInteger newThreadId = new AtomicInteger();
    private static final ConcurrentMap<Thread, ThreadContext> mapContexts = new ConcurrentHashMap<Thread, ThreadContext>(1000);
    private final Thread thread;
    private final Serializer serializer = new Serializer();
    private final Map<FactoryImpl, HazelcastInstanceThreadContext> mapHazelcastInstanceContexts = new HashMap<FactoryImpl, HazelcastInstanceThreadContext>(2);
    private volatile FactoryImpl currentFactory = null;

    private ThreadContext(Thread thread) {
        this.thread = thread;
    }

    public static ThreadContext get() {
        Thread currentThread = Thread.currentThread();
        ThreadContext threadContext = (ThreadContext)mapContexts.get(currentThread);
        if (threadContext == null) {
            try {
                threadContext = new ThreadContext(Thread.currentThread());
                mapContexts.put(currentThread, threadContext);
                Iterator threads = mapContexts.keySet().iterator();
                while (threads.hasNext()) {
                    Thread thread = (Thread)threads.next();
                    if (thread.isAlive()) continue;
                    threads.remove();
                }
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                throw e;
            }
            if (mapContexts.size() > 1000) {
                String msg = " ThreadContext is created!! You might have too many threads. Is that normal?";
                Logger.getLogger(ThreadContext.class.getName()).log(Level.WARNING, mapContexts.size() + msg);
            }
        }
        return threadContext;
    }

    public static void shutdownAll() {
        mapContexts.clear();
    }

    public static synchronized void shutdown(Thread thread) {
        ThreadContext threadContext = (ThreadContext)mapContexts.remove(thread);
        if (threadContext != null) {
            threadContext.shutdown();
        }
    }

    public void shutdown() {
        this.currentFactory = null;
        this.mapHazelcastInstanceContexts.clear();
    }

    public void shutdown(FactoryImpl factory) {
        this.mapHazelcastInstanceContexts.remove(factory);
    }

    public void finalizeTxn() {
        this.getCallContext().finalizeTransaction();
    }

    public TransactionImpl getTransaction() {
        return this.getCallContext().getTransaction();
    }

    public long getTxnId() {
        return this.getCallContext().getTxnId();
    }

    public FactoryImpl getCurrentFactory() {
        return this.currentFactory;
    }

    public ManagedContext getCurrentManagedContext() {
        return this.currentFactory != null ? this.currentFactory.managedContext : null;
    }

    public void setCurrentFactory(FactoryImpl currentFactory) {
        this.currentFactory = currentFactory;
    }

    public void reset() {
        this.finalizeTxn();
    }

    public byte[] toByteArray(Object obj) {
        return this.serializer.toByteArray(obj);
    }

    public Data toData(Object obj) {
        return this.serializer.writeObject(obj);
    }

    public Object toObject(Data data) {
        return this.serializer.readObject(data);
    }

    public HazelcastInstanceThreadContext getHazelcastInstanceThreadContext(FactoryImpl factory) {
        HazelcastInstanceThreadContext hic;
        if (factory == null) {
            ILogger logger = Logger.getLogger(ThreadContext.class.getName());
            logger.log(Level.SEVERE, "Factory is null", new Throwable());
        }
        if ((hic = this.mapHazelcastInstanceContexts.get(factory)) != null) {
            return hic;
        }
        hic = new HazelcastInstanceThreadContext(factory);
        this.mapHazelcastInstanceContexts.put(factory, hic);
        return hic;
    }

    public CallCache getCallCache(FactoryImpl factory) {
        return this.getHazelcastInstanceThreadContext(factory).getCallCache();
    }

    public boolean isClient() {
        return this.getCallContext().isClient();
    }

    public int createNewThreadId() {
        return newThreadId.incrementAndGet();
    }

    public CallContext getCallContext() {
        return this.getHazelcastInstanceThreadContext(this.currentFactory).getCallContext();
    }

    public int getThreadId() {
        return this.getCallContext().getThreadId();
    }

    public void setCallContext(CallContext callContext) {
        this.getHazelcastInstanceThreadContext(this.currentFactory).setCallContext(callContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadContext that = (ThreadContext)o;
        return !(this.thread != null ? !this.thread.equals(that.thread) : that.thread != null);
    }

    public int hashCode() {
        return this.thread != null ? this.thread.hashCode() : 0;
    }

    class CallCache {
        final FactoryImpl factory;
        final ConcurrentMapManager.MPut mput;
        final ConcurrentMapManager.MGet mget;
        final ConcurrentMapManager.MRemove mremove;
        final ConcurrentMapManager.MEvict mevict;

        CallCache(FactoryImpl factory) {
            this.factory = factory;
            this.mput = factory.node.concurrentMapManager.new ConcurrentMapManager.MPut();
            this.mget = factory.node.concurrentMapManager.new ConcurrentMapManager.MGet();
            this.mremove = factory.node.concurrentMapManager.new ConcurrentMapManager.MRemove();
            this.mevict = factory.node.concurrentMapManager.new ConcurrentMapManager.MEvict();
        }

        public ConcurrentMapManager.MPut getMPut() {
            this.mput.reset();
            this.mput.request.lastTime = System.nanoTime();
            return this.mput;
        }

        public ConcurrentMapManager.MGet getMGet() {
            this.mget.reset();
            this.mget.request.lastTime = System.nanoTime();
            return this.mget;
        }

        public ConcurrentMapManager.MRemove getMRemove() {
            this.mremove.reset();
            this.mremove.request.lastTime = System.nanoTime();
            return this.mremove;
        }

        public ConcurrentMapManager.MEvict getMEvict() {
            this.mevict.reset();
            return this.mevict;
        }
    }

    class HazelcastInstanceThreadContext {
        FactoryImpl factory;
        CallCache callCache;
        volatile CallContext callContext = null;

        HazelcastInstanceThreadContext(FactoryImpl factory) {
            this.factory = factory;
            this.callContext = new CallContext(ThreadContext.this.createNewThreadId(), false);
        }

        public CallCache getCallCache() {
            if (this.callCache == null) {
                this.callCache = new CallCache(this.factory);
            }
            return this.callCache;
        }

        public FactoryImpl getFactory() {
            return this.factory;
        }

        public CallContext getCallContext() {
            return this.callContext;
        }

        public void setCallContext(CallContext callContext) {
            this.callContext = callContext;
        }
    }
}

