/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.RAckHeader;

public class RAck
extends SIPHeader
implements RAckHeader {
    private static final long serialVersionUID = 743999286077404118L;
    protected long cSeqNumber;
    protected long rSeqNumber;
    protected String method;

    public RAck() {
        super("RAck");
    }

    protected String encodeBody() {
        return this.rSeqNumber + " " + this.cSeqNumber + " " + this.method;
    }

    public int getCSeqNumber() {
        return (int)this.cSeqNumber;
    }

    public long getCSeqNumberLong() {
        return this.cSeqNumber;
    }

    public String getMethod() {
        return this.method;
    }

    public int getRSeqNumber() {
        return (int)this.rSeqNumber;
    }

    public void setCSeqNumber(int n) throws InvalidArgumentException {
        this.setCSequenceNumber(n);
    }

    public void setMethod(String string) throws ParseException {
        this.method = string;
    }

    public long getCSequenceNumber() {
        return this.cSeqNumber;
    }

    public long getRSequenceNumber() {
        return this.rSeqNumber;
    }

    public void setCSequenceNumber(long l) throws InvalidArgumentException {
        if (l <= 0L || l > 0x80000000L) {
            throw new InvalidArgumentException("Bad CSeq # " + l);
        }
        this.cSeqNumber = l;
    }

    public void setRSeqNumber(int n) throws InvalidArgumentException {
        this.setRSequenceNumber(n);
    }

    public void setRSequenceNumber(long l) throws InvalidArgumentException {
        if (l <= 0L || this.cSeqNumber > 0x80000000L) {
            throw new InvalidArgumentException("Bad rSeq # " + l);
        }
        this.rSeqNumber = l;
    }
}

