/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class Roster
extends IQ {
    public Roster() {
        this.element.addElement("query", "jabber:iq:roster");
    }

    public Roster(IQ.Type type) {
        super(type);
        this.element.addElement("query", "jabber:iq:roster");
    }

    public Roster(IQ.Type type, String ID) {
        super(type, ID);
        this.element.addElement("query", "jabber:iq:roster");
    }

    private Roster(Roster roster) {
        Element elementCopy = roster.element.createCopy();
        docFactory.createDocument().add(elementCopy);
        this.element = elementCopy;
    }

    public Roster(Element element) {
        super(element);
    }

    public Item addItem(String jid, Subscription subscription) {
        if (this.getType() == IQ.Type.get || this.getType() == IQ.Type.error) {
            throw new IllegalStateException("IQ type must be 'result' or 'set'");
        }
        if (jid == null) {
            throw new NullPointerException("JID cannot be null");
        }
        return this.addItem(new JID(jid), null, null, subscription, null);
    }

    public Item addItem(JID jid, Subscription subscription) {
        if (this.getType() != IQ.Type.result && this.getType() != IQ.Type.set) {
            throw new IllegalStateException("IQ type must be 'result' or 'set'");
        }
        if (jid == null) {
            throw new NullPointerException("JID cannot be null");
        }
        return this.addItem(jid, null, null, subscription, null);
    }

    public Item addItem(JID jid, String name, Ask ask, Subscription subscription, Collection<String> groups) {
        if (jid == null) {
            throw new NullPointerException("JID cannot be null");
        }
        if (subscription == null) {
            throw new NullPointerException("Subscription cannot be null");
        }
        Element query = this.element.element(new QName("query", Namespace.get((String)"jabber:iq:roster")));
        if (query == null) {
            query = this.element.addElement("query", "jabber:iq:roster");
        }
        Element item = null;
        Iterator i = query.elementIterator("item");
        while (i.hasNext()) {
            Element el = (Element)i.next();
            if (!el.attributeValue("jid").equals(jid.toString())) continue;
            item = el;
        }
        if (item == null) {
            item = query.addElement("item");
        }
        item.addAttribute("jid", jid.toBareJID());
        item.addAttribute("name", name);
        if (ask != null) {
            item.addAttribute("ask", ask.toString());
        }
        item.addAttribute("subscription", subscription.toString());
        i = item.elementIterator("group");
        while (i.hasNext()) {
            item.remove((Element)i.next());
        }
        if (groups != null) {
            for (String group : groups) {
                item.addElement("group").setText(group);
            }
        }
        return new Item(jid, name, ask, subscription, groups);
    }

    public void removeItem(JID jid) {
        Element query = this.element.element(new QName("query", Namespace.get((String)"jabber:iq:roster")));
        if (query != null) {
            Iterator i = query.elementIterator("item");
            while (i.hasNext()) {
                Element item = (Element)i.next();
                if (!item.attributeValue("jid").equals(jid.toString())) continue;
                query.remove(item);
                return;
            }
        }
    }

    public Collection<Item> getItems() {
        ArrayList<Item> items = new ArrayList<Item>();
        Element query = this.element.element(new QName("query", Namespace.get((String)"jabber:iq:roster")));
        if (query != null) {
            Iterator i = query.elementIterator("item");
            while (i.hasNext()) {
                Element item = (Element)i.next();
                String jid = item.attributeValue("jid");
                String name = item.attributeValue("name");
                String ask = item.attributeValue("ask");
                String subscription = item.attributeValue("subscription");
                ArrayList<String> groups = new ArrayList<String>();
                Iterator j = item.elementIterator("group");
                while (j.hasNext()) {
                    Element group = (Element)j.next();
                    groups.add(group.getText().trim());
                }
                Ask askStatus = ask == null ? null : Ask.valueOf(ask);
                Subscription subStatus = subscription == null ? null : Subscription.valueOf(subscription);
                items.add(new Item(new JID(jid), name, askStatus, subStatus, groups));
            }
        }
        return Collections.unmodifiableCollection(items);
    }

    @Override
    public Roster createCopy() {
        return new Roster(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Ask {
        subscribe,
        unsubscribe;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Subscription {
        none,
        to,
        from,
        both,
        remove;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Item {
        private JID jid;
        private String name;
        private Ask ask;
        private Subscription subscription;
        private Collection<String> groups;

        private Item(JID jid, String name, Ask ask, Subscription subscription, Collection<String> groups) {
            this.jid = jid;
            this.name = name;
            this.ask = ask;
            this.subscription = subscription;
            this.groups = groups;
        }

        public JID getJID() {
            return this.jid;
        }

        public String getName() {
            return this.name;
        }

        public Ask getAsk() {
            return this.ask;
        }

        public Subscription getSubscription() {
            return this.subscription;
        }

        public Collection<String> getGroups() {
            if (this.groups == null) {
                return Collections.emptyList();
            }
            return this.groups;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("<item ");
            buf.append("jid=\"").append(this.jid).append("\"");
            if (this.name != null) {
                buf.append(" name=\"").append(this.name).append("\"");
            }
            buf.append(" subscrption=\"").append((Object)this.subscription).append("\"");
            if (this.groups == null || this.groups.isEmpty()) {
                buf.append("/>");
            } else {
                buf.append(">\n");
                for (String group : this.groups) {
                    buf.append("  <group>").append(group).append("</group>\n");
                }
                buf.append("</item>");
            }
            return buf.toString();
        }
    }
}

