/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.JoinOperation;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;

public class AuthorizationOperation
extends AbstractOperation
implements JoinOperation {
    private String groupName;
    private String groupPassword;
    private Boolean response = Boolean.TRUE;

    public AuthorizationOperation() {
    }

    public AuthorizationOperation(String groupName, String groupPassword) {
        this.groupName = groupName;
        this.groupPassword = groupPassword;
    }

    @Override
    public void run() {
        GroupConfig groupConfig = this.getNodeEngine().getConfig().getGroupConfig();
        if (!this.groupName.equals(groupConfig.getName())) {
            this.response = Boolean.FALSE;
        } else if (!this.groupPassword.equals(groupConfig.getPassword())) {
            this.response = Boolean.FALSE;
        }
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.groupName = in.readUTF();
        this.groupPassword = in.readUTF();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.groupName);
        out.writeUTF(this.groupPassword);
    }
}

