/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import org.jrobin.core.Util;

class Source {
    protected static final int AGG_MINIMUM = 0;
    protected static final int AGG_MAXIMUM = 1;
    protected static final int AGG_AVERAGE = 2;
    protected static final int AGG_FIRST = 3;
    protected static final int AGG_LAST = 4;
    protected static final int AGG_TOTAL = 5;
    protected static final String[] aggregates = new String[]{"MINIMUM", "MAXIMUM", "AVERAGE", "FIRST", "LAST", "TOTAL"};
    private String name;
    protected int aggregatePoints;
    protected double[] values;
    private double min = Double.NaN;
    private double max = Double.NaN;
    private double lastValue = Double.NaN;
    private double totalValue = 0.0;
    private double nextValue = Double.POSITIVE_INFINITY;
    protected long step = 0L;
    private long lastPreciseTime = 0L;
    private long lastTime = 0L;
    private long totalTime = 0L;
    private int stPos = 0;
    private int lastStPos = 0;

    Source(String name) {
        this.name = name;
    }

    void set(int pos, long time, double val) {
        if (pos > 0 && pos < this.aggregatePoints) {
            this.aggregate(time, val);
        }
    }

    void setFetchedStep(long step) {
        this.step = step;
    }

    long getStep() {
        return this.step;
    }

    double get(int pos) {
        if (pos < 0) {
            return Double.NaN;
        }
        if (pos > this.values.length) {
            return Double.NaN;
        }
        double val = this.values[pos];
        if (Double.isInfinite(val)) {
            if (!Double.isInfinite(this.nextValue) && pos >= this.lastStPos) {
                return this.nextValue;
            }
            this.lastStPos = pos;
            for (int i = pos + 1; i < this.values.length; ++i) {
                if (Double.isInfinite(this.values[i])) continue;
                this.nextValue = this.values[i];
                return this.nextValue;
            }
            this.nextValue = Double.NaN;
            return this.nextValue;
        }
        this.nextValue = Double.POSITIVE_INFINITY;
        this.lastStPos = pos;
        return this.values[pos];
    }

    double get(long preciseTime, long[] reducedTimestamps) {
        long t = Util.normalize(preciseTime, this.step);
        long l = t = t < preciseTime ? t + this.step : t;
        if (preciseTime < this.lastPreciseTime) {
            this.stPos = 0;
        }
        this.lastPreciseTime = preciseTime;
        while (this.stPos < reducedTimestamps.length - 1) {
            if (reducedTimestamps[this.stPos + 1] <= t) {
                ++this.stPos;
                continue;
            }
            return this.get(this.stPos);
        }
        if (t <= reducedTimestamps[this.stPos]) {
            return this.get(this.stPos);
        }
        return Double.NaN;
    }

    double getAggregate(int aggType) {
        switch (aggType) {
            case 0: {
                return this.min;
            }
            case 1: {
                return this.max;
            }
            case 2: {
                if (this.totalTime <= 0L) break;
                return this.totalValue / (double)this.totalTime;
            }
            case 3: {
                if (this.values == null || this.values.length <= 0) break;
                return this.values[0];
            }
            case 4: {
                if (this.values == null || this.values.length <= 0) break;
                return this.values[this.values.length - 1];
            }
            case 5: {
                return this.totalValue;
            }
        }
        return Double.NaN;
    }

    String getName() {
        return this.name;
    }

    double[] getValues() {
        return this.values;
    }

    long getSampleCount() {
        return this.values != null ? this.values.length : 0;
    }

    private void aggregate(long time, double value) {
        if (Double.isInfinite(value)) {
            return;
        }
        this.min = Util.min(this.min, value);
        this.max = Util.max(this.max, value);
        if (!Double.isNaN(this.lastValue) && !Double.isNaN(value)) {
            long timeDelta = time - this.lastTime;
            this.totalValue += (double)timeDelta * (value + this.lastValue) / 2.0;
            this.totalTime += timeDelta;
        }
        this.lastTime = time;
        this.lastValue = value;
    }
}

