/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.IOException;
import java.util.ArrayList;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdOpener;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.FetchSourceList;
import org.jrobin.graph.ValueExtractor;

class FetchSource {
    protected static final int AVG = 0;
    protected static final int MAX = 1;
    protected static final int MIN = 2;
    protected static final int LAST = 3;
    protected static final int MAX_CF = 4;
    protected static final String[] cfNames = new String[]{"AVERAGE", "MAX", "MIN", "LAST"};
    private RrdDb rrd;
    private RrdDef rrdDef;
    private String rrdFile;
    private String backendName;
    private int numSources = 0;
    private ArrayList[] datasources = new ArrayList[4];
    private FetchSourceList listReference = null;

    protected FetchSource(String rrdFile, FetchSourceList listRef) {
        this.rrdFile = rrdFile;
        this.listReference = listRef;
        for (int i = 0; i < this.datasources.length; ++i) {
            this.datasources[i] = new ArrayList(10);
        }
    }

    protected FetchSource(String rrdFile, String consolFunc, String dsName, String name, FetchSourceList listRef) throws RrdException {
        this(rrdFile, listRef);
        this.addSource(consolFunc, dsName, name);
    }

    protected FetchSource(String rrdFile, String consolFunc, String dsName, String name, String backendName, FetchSourceList listRef) throws RrdException {
        this(rrdFile, consolFunc, dsName, name, listRef);
        this.setBackendFactory(backendName);
    }

    protected void addSource(String consolFunc, String dsName, String name) throws RrdException {
        if (consolFunc.equalsIgnoreCase("AVERAGE") || consolFunc.equalsIgnoreCase("AVG")) {
            this.datasources[0].add(new String[]{dsName, name});
        } else if (consolFunc.equalsIgnoreCase("MAX") || consolFunc.equalsIgnoreCase("MAXIMUM")) {
            this.datasources[1].add(new String[]{dsName, name});
        } else if (consolFunc.equalsIgnoreCase("MIN") || consolFunc.equalsIgnoreCase("MINIMUM")) {
            this.datasources[2].add(new String[]{dsName, name});
        } else if (consolFunc.equalsIgnoreCase("LAST")) {
            this.datasources[3].add(new String[]{dsName, name});
        } else {
            throw new RrdException("Invalid consolidation function specified.");
        }
        ++this.numSources;
    }

    protected void setBackendFactory(String backendName) {
        this.backendName = backendName;
    }

    protected ValueExtractor fetch(long startTime, long endTime, long resolution, int reduceFactor) throws IOException, RrdException {
        if (this.rrd == null) {
            this.openRrd();
        }
        int dsSize = 0;
        long rrdStep = this.rrdDef.getStep();
        FetchData[] result = new FetchData[this.datasources.length];
        String[] names = new String[this.numSources];
        int tblPos = 0;
        for (int i = 0; i < this.datasources.length; ++i) {
            dsSize = this.datasources[i].size();
            if (dsSize <= 0) continue;
            String[] dsNames = new String[dsSize];
            String[] vNames = new String[dsSize];
            for (int j = 0; j < dsSize; ++j) {
                String[] spair = (String[])this.datasources[i].get(j);
                dsNames[j] = spair[0];
                vNames[j] = spair[1];
            }
            FetchRequest request = this.rrd.createFetchRequest(cfNames[i], startTime, endTime, resolution);
            request.setFilter(dsNames);
            FetchData data = request.fetchData();
            for (int j = 0; j < dsSize; ++j) {
                names[data.getDsIndex((String)dsNames[j]) + tblPos] = vNames[j];
            }
            tblPos += dsSize;
            result[i] = data;
        }
        return new ValueExtractor(names, result, reduceFactor);
    }

    protected void openRrd() throws RrdException, IOException {
        if (this.rrd == null) {
            RrdOpener opener = this.listReference.getRrdOpener();
            if (opener == null) {
                throw new RrdException("No RrdOpener specified for RRD management.");
            }
            if (this.rrd == null) {
                this.rrd = opener.getRrd(this.rrdFile, this.getRrdBackendFactory());
            }
            this.rrdDef = this.rrd.getRrdDef();
        }
    }

    protected RrdDb getRrd() throws RrdException, IOException {
        if (this.rrd == null) {
            this.openRrd();
        }
        return this.rrd;
    }

    protected void release() throws RrdException, IOException {
        if (this.rrd != null) {
            RrdOpener opener = this.listReference.getRrdOpener();
            if (opener == null) {
                throw new RrdException("No RrdOpener specified for RRD management.");
            }
            opener.releaseRrd(this.rrd);
            this.rrd = null;
        }
    }

    protected long getLastSampleTime(long startTime, long endTime, long resolution) throws RrdException, IOException {
        if (this.rrd == null) {
            this.openRrd();
        }
        long minSampleTime = Long.MAX_VALUE;
        long sampleTime = 0L;
        for (int i = 0; i < this.datasources.length; ++i) {
            if (this.datasources[i].size() <= 0 || (sampleTime = this.rrd.findStartMatchArchive(cfNames[i], startTime, resolution).getEndTime()) >= minSampleTime) continue;
            minSampleTime = sampleTime;
        }
        return minSampleTime;
    }

    protected long[] getFetchStep(long startTime, long endTime, long resolution) throws RrdException, IOException {
        if (this.rrd == null) {
            this.openRrd();
        }
        long maxStep = Long.MIN_VALUE;
        long minStep = Long.MAX_VALUE;
        long step = 0L;
        for (int i = 0; i < this.datasources.length; ++i) {
            if (this.datasources[i].size() <= 0) continue;
            FetchRequest request = this.rrd.createFetchRequest(cfNames[i], startTime, endTime, resolution);
            step = this.rrd.findMatchingArchive(request).getArcStep();
            if (step < minStep) {
                minStep = step;
            }
            if (step <= maxStep) continue;
            maxStep = step;
        }
        return new long[]{minStep, maxStep};
    }

    protected String getRrdFile() {
        return this.rrdFile;
    }

    protected RrdBackendFactory getRrdBackendFactory() throws RrdException {
        if (this.backendName != null) {
            return RrdBackendFactory.getFactory(this.backendName);
        }
        return RrdBackendFactory.getDefaultFactory();
    }

    public void exportXml(XmlWriter xml) {
        for (int i = 0; i < this.datasources.length; ++i) {
            for (int j = 0; j < this.datasources[i].size(); ++j) {
                String[] pair = (String[])this.datasources[i].get(j);
                xml.startTag("def");
                xml.writeTag("name", pair[1]);
                xml.writeTag("rrd", this.rrdFile);
                xml.writeTag("source", pair[0]);
                xml.writeTag("cf", cfNames[i]);
                xml.closeTag();
            }
        }
    }
}

