/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

public class DsDef {
    public static final String[] DS_TYPES = new String[]{"GAUGE", "COUNTER", "DERIVE", "ABSOLUTE"};
    private String dsName;
    private String dsType;
    private long heartbeat;
    private double minValue;
    private double maxValue;

    public DsDef(String dsName, String dsType, long heartbeat, double minValue, double maxValue) throws RrdException {
        this.dsName = dsName;
        this.dsType = dsType;
        this.heartbeat = heartbeat;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.validate();
    }

    public String getDsName() {
        return this.dsName;
    }

    public String getDsType() {
        return this.dsType;
    }

    public long getHeartbeat() {
        return this.heartbeat;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    private void validate() throws RrdException {
        if (this.dsName == null || this.dsName.length() == 0) {
            throw new RrdException("Invalid datasource name specified");
        }
        if (!DsDef.isValidDsType(this.dsType)) {
            throw new RrdException("Invalid datasource type specified: " + this.dsType);
        }
        if (this.heartbeat <= 0L) {
            throw new RrdException("Invalid heartbeat, must be positive: " + this.heartbeat);
        }
        if (!Double.isNaN(this.minValue) && !Double.isNaN(this.maxValue) && this.minValue >= this.maxValue) {
            throw new RrdException("Invalid min/max values specified: " + this.minValue + "/" + this.maxValue);
        }
    }

    public static boolean isValidDsType(String dsType) {
        for (int i = 0; i < DS_TYPES.length; ++i) {
            if (!DS_TYPES[i].equals(dsType)) continue;
            return true;
        }
        return false;
    }

    public String dump() {
        return "DS:" + this.dsName + ":" + this.dsType + ":" + this.heartbeat + ":" + Util.formatDouble(this.minValue, "U", false) + ":" + Util.formatDouble(this.maxValue, "U", false);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DsDef) {
            DsDef dsObj = (DsDef)obj;
            return this.dsName.equals(dsObj.dsName);
        }
        return false;
    }

    boolean exactlyEqual(DsDef def) {
        return this.dsName.equals(def.dsName) && this.dsType.equals(def.dsType) && this.heartbeat == def.heartbeat && Util.equal(this.minValue, def.minValue) && Util.equal(this.maxValue, def.maxValue);
    }
}

