/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import java.io.File;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.Rmic;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.JavaEnvUtils;

public abstract class DefaultRmicAdapter
implements RmicAdapter {
    private static final Random rand = new Random();
    private Rmic attributes;
    private FileNameMapper mapper;

    public void setRmic(Rmic rmic) {
        this.attributes = rmic;
        this.mapper = new RmicFileNameMapper();
    }

    public Rmic getRmic() {
        return this.attributes;
    }

    protected String getStubClassSuffix() {
        return "_Stub";
    }

    protected String getSkelClassSuffix() {
        return "_Skel";
    }

    protected String getTieClassSuffix() {
        return "_Tie";
    }

    public FileNameMapper getMapper() {
        return this.mapper;
    }

    public Path getClasspath() {
        return this.getCompileClasspath();
    }

    protected Path getCompileClasspath() {
        Path path = new Path(this.attributes.getProject());
        path.setLocation(this.attributes.getBase());
        Path path2 = this.attributes.getClasspath();
        if (path2 == null) {
            path2 = new Path(this.attributes.getProject());
        }
        if (this.attributes.getIncludeantruntime()) {
            path.addExisting(path2.concatSystemClasspath("last"));
        } else {
            path.addExisting(path2.concatSystemClasspath("ignore"));
        }
        if (this.attributes.getIncludejavaruntime()) {
            path.addJavaRuntime();
        }
        return path;
    }

    protected Commandline setupRmicCommand() {
        return this.setupRmicCommand(null);
    }

    protected Commandline setupRmicCommand(String[] stringArray) {
        Commandline commandline = new Commandline();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                commandline.createArgument().setValue(stringArray[n]);
                ++n;
            }
        }
        Path path = this.getCompileClasspath();
        commandline.createArgument().setValue("-d");
        commandline.createArgument().setFile(this.attributes.getBase());
        if (this.attributes.getExtdirs() != null) {
            if (JavaEnvUtils.isJavaVersion("1.1")) {
                path.addExtdirs(this.attributes.getExtdirs());
            } else {
                commandline.createArgument().setValue("-extdirs");
                commandline.createArgument().setPath(this.attributes.getExtdirs());
            }
        }
        commandline.createArgument().setValue("-classpath");
        commandline.createArgument().setPath(path);
        String string = this.attributes.getStubVersion();
        if (string != null) {
            if ("1.1".equals(string)) {
                commandline.createArgument().setValue("-v1.1");
            } else if ("1.2".equals(string)) {
                commandline.createArgument().setValue("-v1.2");
            } else {
                commandline.createArgument().setValue("-vcompat");
            }
        }
        if (this.attributes.getSourceBase() != null) {
            commandline.createArgument().setValue("-keepgenerated");
        }
        if (this.attributes.getIiop()) {
            this.attributes.log("IIOP has been turned on.", 2);
            commandline.createArgument().setValue("-iiop");
            if (this.attributes.getIiopopts() != null) {
                this.attributes.log("IIOP Options: " + this.attributes.getIiopopts(), 2);
                commandline.createArgument().setValue(this.attributes.getIiopopts());
            }
        }
        if (this.attributes.getIdl()) {
            commandline.createArgument().setValue("-idl");
            this.attributes.log("IDL has been turned on.", 2);
            if (this.attributes.getIdlopts() != null) {
                commandline.createArgument().setValue(this.attributes.getIdlopts());
                this.attributes.log("IDL Options: " + this.attributes.getIdlopts(), 2);
            }
        }
        if (this.attributes.getDebug()) {
            commandline.createArgument().setValue("-g");
        }
        commandline.addArguments(this.attributes.getCurrentCompilerArgs());
        this.logAndAddFilesToCompile(commandline);
        return commandline;
    }

    protected void logAndAddFilesToCompile(Commandline commandline) {
        Vector vector = this.attributes.getCompileList();
        this.attributes.log("Compilation " + commandline.describeArguments(), 3);
        StringBuffer stringBuffer = new StringBuffer("File");
        if (vector.size() != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(" to be compiled:");
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            commandline.createArgument().setValue(string);
            stringBuffer.append("    " + string);
            ++n;
        }
        this.attributes.log(stringBuffer.toString(), 3);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RmicFileNameMapper
    implements FileNameMapper {
        public void setFrom(String string) {
        }

        public void setTo(String string) {
        }

        public String[] mapFileName(String string) {
            if (string == null || !string.endsWith(".class") || string.endsWith(DefaultRmicAdapter.this.getStubClassSuffix() + ".class") || string.endsWith(DefaultRmicAdapter.this.getSkelClassSuffix() + ".class") || string.endsWith(DefaultRmicAdapter.this.getTieClassSuffix() + ".class")) {
                return null;
            }
            String string2 = string.substring(0, string.length() - 6);
            String string3 = string2.replace(File.separatorChar, '.');
            if (DefaultRmicAdapter.this.attributes.getVerify() && !DefaultRmicAdapter.this.attributes.isValidRmiRemote(string3)) {
                return null;
            }
            String[] stringArray = new String[]{string + ".tmp." + rand.nextLong()};
            if (!DefaultRmicAdapter.this.attributes.getIiop() && !DefaultRmicAdapter.this.attributes.getIdl()) {
                stringArray = "1.2".equals(DefaultRmicAdapter.this.attributes.getStubVersion()) ? new String[]{string2 + DefaultRmicAdapter.this.getStubClassSuffix() + ".class"} : new String[]{string2 + DefaultRmicAdapter.this.getStubClassSuffix() + ".class", string2 + DefaultRmicAdapter.this.getSkelClassSuffix() + ".class"};
            } else if (!DefaultRmicAdapter.this.attributes.getIdl()) {
                int n = string2.lastIndexOf(File.separatorChar);
                String string4 = "";
                int n2 = -1;
                if (n == -1) {
                    n2 = 0;
                } else {
                    n2 = n + 1;
                    string4 = string2.substring(0, n2);
                }
                String string5 = string2.substring(n2);
                try {
                    Class<?> clazz = DefaultRmicAdapter.this.attributes.getLoader().loadClass(string3);
                    if (clazz.isInterface()) {
                        stringArray = new String[]{string4 + '_' + string5 + DefaultRmicAdapter.this.getStubClassSuffix() + ".class"};
                    } else {
                        Class clazz2 = DefaultRmicAdapter.this.attributes.getRemoteInterface(clazz);
                        String string6 = clazz2.getName();
                        String string7 = "";
                        int n3 = -1;
                        int n4 = string6.lastIndexOf(".");
                        if (n4 == -1) {
                            n3 = 0;
                        } else {
                            n3 = n4 + 1;
                            string7 = string6.substring(0, n3);
                            string7 = string7.replace('.', File.separatorChar);
                        }
                        stringArray = new String[]{string4 + '_' + string5 + DefaultRmicAdapter.this.getTieClassSuffix() + ".class", string7 + '_' + string6.substring(n3) + DefaultRmicAdapter.this.getStubClassSuffix() + ".class"};
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    DefaultRmicAdapter.this.attributes.log("Unable to verify class " + string3 + ". It could not be found.", 1);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    DefaultRmicAdapter.this.attributes.log("Unable to verify class " + string3 + ". It is not defined.", 1);
                }
                catch (Throwable throwable) {
                    DefaultRmicAdapter.this.attributes.log("Unable to verify class " + string3 + ". Loading caused Exception: " + throwable.getMessage(), 1);
                }
            }
            return stringArray;
        }

        RmicFileNameMapper() {
        }
    }
}

