/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.sentinel.protocols;

import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SentinelEncoder {
    private static final Logger Log = Logger.getLogger(SentinelEncoder.class);
    HashMap<Integer, String> clientDictionary;
    HashMap<Integer, String> serverDictionary;
    PrintWriter out;
    boolean isServer = false;

    public SentinelEncoder(PrintWriter out, boolean isServer) {
        this.isServer = isServer;
        this.out = out;
        this.clientDictionary = new HashMap(100);
        this.serverDictionary = new HashMap(100);
        this.buildDictionary();
    }

    private void buildDictionary() {
        this.clientDictionary.put(new Integer(0), "PONG");
        this.clientDictionary.put(new Integer(1), "HNDSHK");
        this.clientDictionary.put(new Integer(2), "BYE");
        this.serverDictionary.put(new Integer(0), "PING");
        this.serverDictionary.put(new Integer(1), "HNDSHK");
        this.serverDictionary.put(new Integer(2), "GO");
        this.serverDictionary.put(new Integer(3), "THX");
    }

    public void sendMsg(int incomingCommand) {
        String msg = "";
        if (this.isServer) {
            msg = this.serverDictionary.get(new Integer(incomingCommand));
            if (msg != null) {
                Log.debug((Object)("Server sent: " + msg));
                this.out.println(msg);
            }
        } else {
            msg = this.clientDictionary.get(new Integer(incomingCommand));
            if (msg != null) {
                Log.debug((Object)("Client sent: " + msg));
                this.out.println(msg);
            }
        }
    }

    public void sendCustomMsg(String msg) {
        Log.debug((Object)("Someone is sending this: " + msg));
        this.out.println(msg);
    }
}

