/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

public final class ByteUtil {
    private static final byte[] POWERS = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};

    private ByteUtil() {
    }

    public static byte setTrue(byte number, int index) {
        return (byte)(number | POWERS[index]);
    }

    public static byte setFalse(byte number, int index) {
        return (byte)(number & ~POWERS[index]);
    }

    public static boolean isTrue(byte number, int index) {
        return (number & POWERS[index]) != 0;
    }

    public static boolean isFalse(byte number, int index) {
        return (number & POWERS[index]) == 0;
    }

    public static byte toByte(boolean ... values) {
        if (values.length > 8) {
            throw new IllegalArgumentException("Expected less or equal to 8 arguments");
        }
        byte b = 0;
        for (int i = 0; i < values.length; ++i) {
            b = (byte)(b | (values[i] ? POWERS[i] : (byte)0));
        }
        return b;
    }

    public static boolean[] fromByte(byte b) {
        boolean[] values = new boolean[8];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (b & POWERS[i]) != 0;
        }
        return values;
    }

    public static String toBinaryString(byte number) {
        StringBuilder builder = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            int q = number & POWERS[7 - i];
            builder.append(q != 0 ? (char)'1' : '0');
        }
        return builder.toString();
    }

    public static byte[] concatenate(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static int combineToInt(short x, short y) {
        return x << 16 | y & 0xFFFF;
    }

    public static short extractShort(int value, boolean lowerBits) {
        return (short)(lowerBits ? value : value >> 16);
    }

    public static long combineToLong(int x, int y) {
        return (long)x << 32 | (long)y & 0xFFFFFFFFL;
    }

    public static int extractInt(long value, boolean lowerBits) {
        return lowerBits ? (int)value : (int)(value >> 32);
    }
}

