/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.core.Client;
import com.hazelcast.management.JsonSerializable;
import com.hazelcast.util.JsonUtil;

public class SerializableClientEndPoint
implements JsonSerializable {
    String uuid;
    String address;
    String clientType;

    public SerializableClientEndPoint() {
    }

    public SerializableClientEndPoint(Client client) {
        this.uuid = client.getUuid();
        this.address = client.getSocketAddress().getHostName() + ":" + client.getSocketAddress().getPort();
        this.clientType = client.getClientType().toString();
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("uuid", this.uuid);
        root.add("address", this.address);
        root.add("clientType", this.clientType);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.uuid = JsonUtil.getString(json, "uuid");
        this.address = JsonUtil.getString(json, "address");
        this.clientType = JsonUtil.getString(json, "clientType");
    }
}

