/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventType;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;

public class CacheEventDataImpl
implements CacheEventData {
    private String name;
    private CacheEventType eventType;
    private Data dataKey;
    private Data dataNewValue;
    private Data dataOldValue;
    private boolean isOldValueAvailable;

    public CacheEventDataImpl() {
    }

    public CacheEventDataImpl(String name, CacheEventType eventType, Data dataKey, Data dataNewValue, Data dataOldValue, boolean isOldValueAvailable) {
        this.name = name;
        this.eventType = eventType;
        this.dataKey = dataKey;
        this.dataNewValue = dataNewValue;
        this.dataOldValue = dataOldValue;
        this.isOldValueAvailable = isOldValueAvailable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CacheEventType getCacheEventType() {
        return this.eventType;
    }

    @Override
    public Data getDataKey() {
        return this.dataKey;
    }

    @Override
    public Data getDataValue() {
        return this.dataNewValue;
    }

    @Override
    public Data getDataOldValue() {
        return this.dataOldValue;
    }

    @Override
    public boolean isOldValueAvailable() {
        return this.isOldValueAvailable;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.eventType.getType());
        this.dataKey.writeData(out);
        IOUtil.writeNullableData(out, this.dataNewValue);
        IOUtil.writeNullableData(out, this.dataOldValue);
        out.writeBoolean(this.isOldValueAvailable);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.eventType = CacheEventType.getByType(in.readInt());
        this.dataKey = IOUtil.readData(in);
        this.dataNewValue = IOUtil.readNullableData(in);
        this.dataOldValue = IOUtil.readNullableData(in);
        this.isOldValueAvailable = in.readBoolean();
    }

    @Override
    public int getId() {
        return 31;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }
}

