/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.controller.MUCRoomController;
import org.jivesoftware.openfire.plugin.rest.entity.MUCRoomEntities;
import org.jivesoftware.openfire.plugin.rest.entity.MUCRoomEntity;
import org.jivesoftware.openfire.plugin.rest.entity.OccupantEntities;
import org.jivesoftware.openfire.plugin.rest.entity.ParticipantEntities;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;

@Path(value="restapi/v1/chatrooms")
public class MUCRoomService {
    @GET
    @Produces(value={"application/xml", "application/json"})
    public MUCRoomEntities getMUCRooms(@DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @DefaultValue(value="public") @QueryParam(value="type") String channelType, @QueryParam(value="search") String roomSearch, @DefaultValue(value="false") @QueryParam(value="expandGroups") Boolean expand) {
        return MUCRoomController.getInstance().getChatRooms(serviceName, channelType, roomSearch, expand);
    }

    @GET
    @Path(value="/{roomName}")
    @Produces(value={"application/xml", "application/json"})
    public MUCRoomEntity getMUCRoomJSON2(@PathParam(value="roomName") String roomName, @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @DefaultValue(value="false") @QueryParam(value="expandGroups") Boolean expand) throws ServiceException {
        return MUCRoomController.getInstance().getChatRoom(roomName, serviceName, expand);
    }

    @DELETE
    @Path(value="/{roomName}")
    public Response deleteMUCRoom(@PathParam(value="roomName") String roomName, @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName) throws ServiceException {
        MUCRoomController.getInstance().deleteChatRoom(roomName, serviceName);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    public Response createMUCRoom(@DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, MUCRoomEntity mucRoomEntity) throws ServiceException {
        MUCRoomController.getInstance().createChatRoom(serviceName, mucRoomEntity);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="/{roomName}")
    public Response udpateMUCRoom(@PathParam(value="roomName") String roomName, @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, MUCRoomEntity mucRoomEntity) throws ServiceException {
        MUCRoomController.getInstance().updateChatRoom(roomName, serviceName, mucRoomEntity);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{roomName}/participants")
    @Produces(value={"application/xml", "application/json"})
    public ParticipantEntities getMUCRoomParticipants(@PathParam(value="roomName") String roomName, @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName) {
        return MUCRoomController.getInstance().getRoomParticipants(roomName, serviceName);
    }

    @GET
    @Path(value="/{roomName}/occupants")
    @Produces(value={"application/xml", "application/json"})
    public OccupantEntities getMUCRoomOccupants(@PathParam(value="roomName") String roomName, @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName) {
        return MUCRoomController.getInstance().getRoomOccupants(roomName, serviceName);
    }
}

