/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.incoming;

import net.sf.jml.MsnClientId;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnUserStatus;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnOwnerImpl;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingCHG;
import net.sf.jml.protocol.outgoing.OutgoingPNG;
import net.sf.jml.util.NumberUtils;
import net.sf.jml.util.StringUtils;

public class IncomingCHG
extends MsnIncomingMessage {
    public IncomingCHG(MsnProtocol msnProtocol) {
        super(msnProtocol);
    }

    public MsnUserStatus getStatus() {
        return MsnUserStatus.parseStr(this.getParam(0));
    }

    public int getClientId() {
        return NumberUtils.stringToInt(this.getParam(1));
    }

    public String getMsnObject() {
        String string = this.getParam(2);
        if (string != null) {
            return StringUtils.urlDecode(string);
        }
        return null;
    }

    protected void messageReceived(MsnSession msnSession) {
        super.messageReceived(msnSession);
        MsnOwnerImpl msnOwnerImpl = (MsnOwnerImpl)msnSession.getMessenger().getOwner();
        msnOwnerImpl.fSetClientId(MsnClientId.parseInt(this.getClientId()));
        msnOwnerImpl.fSetStatusF(this.getStatus());
        ((AbstractMessenger)msnSession.getMessenger()).fireOwnerStatusChanged();
        if (this.getOutgoingMessage() instanceof OutgoingCHG && ((OutgoingCHG)this.getOutgoingMessage()).isFirstSend()) {
            OutgoingPNG outgoingPNG = new OutgoingPNG(this.protocol);
            outgoingPNG.setForCheckContactListInitCompleted(true);
            msnSession.sendAsynchronousMessage(outgoingPNG);
        }
    }
}

