/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpOnlyCookie;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionContext;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;

public abstract class AbstractSessionManager
implements SessionManager {
    private static Log log = LogFactory.getLog(class$org$mortbay$jetty$servlet$AbstractSessionManager == null ? (class$org$mortbay$jetty$servlet$AbstractSessionManager = AbstractSessionManager.class$("org.mortbay.jetty.servlet.AbstractSessionManager")) : class$org$mortbay$jetty$servlet$AbstractSessionManager);
    public static final int __distantFuture = 628992000;
    private static final String __NEW_SESSION_ID = "org.mortbay.jetty.newSessionId";
    protected static MultiMap __allSessions = new MultiMap();
    private int _dftMaxIdleSecs = -1;
    private int _scavengePeriodMs = 30000;
    private String _workerName;
    protected transient ArrayList _sessionListeners = new ArrayList();
    protected transient ArrayList _sessionAttributeListeners = new ArrayList();
    protected transient Map _sessions;
    protected transient Random _random;
    protected transient ServletHandler _handler;
    protected int _minSessions = 0;
    protected int _maxSessions = 0;
    protected boolean _crossContextSessionIDs = false;
    protected boolean _secureCookies = false;
    protected boolean _httpOnly = false;
    protected boolean _invalidateGlobal = true;
    private transient SessionScavenger _scavenger = null;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$AbstractSessionManager;

    public AbstractSessionManager() {
        this(null);
    }

    public AbstractSessionManager(Random random) {
        this._random = random;
    }

    public boolean getUseRequestedId() {
        return this._crossContextSessionIDs;
    }

    public void setUseRequestedId(boolean useRequestedId) {
        this._crossContextSessionIDs = useRequestedId;
    }

    public boolean getCrossContextSessionIDs() {
        return this._crossContextSessionIDs;
    }

    public void setCrossContextSessionIDs(boolean useRequestedId) {
        this._crossContextSessionIDs = useRequestedId;
    }

    public void initialize(ServletHandler handler) {
        this._handler = handler;
    }

    public Map getSessionMap() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public int getSessions() {
        return this._sessions.size();
    }

    public int getMinSessions() {
        return this._minSessions;
    }

    public int getMaxSessions() {
        return this._maxSessions;
    }

    public void resetStats() {
        this._minSessions = this._sessions.size();
        this._maxSessions = this._sessions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newSessionId(HttpServletRequest request, long created) {
        MultiMap multiMap = __allSessions;
        synchronized (multiMap) {
            if (this._crossContextSessionIDs) {
                String requested_id = (String)request.getAttribute(__NEW_SESSION_ID);
                if (requested_id == null) {
                    requested_id = request.getRequestedSessionId();
                }
                if (requested_id != null && requested_id != null && __allSessions.containsKey(requested_id) && !this._sessions.containsKey(requested_id)) {
                    return requested_id;
                }
            }
            String id = null;
            while (id == null || id.length() == 0 || __allSessions.containsKey(id)) {
                long r = this._random.nextLong();
                if (r < 0L) {
                    r = -r;
                }
                id = Long.toString(r, 30 + (int)(created % 7L));
                String worker = (String)request.getAttribute("org.mortbay.http.ajp.JVMRoute");
                if (worker != null) {
                    id = id + "." + worker;
                    continue;
                }
                if (this._workerName == null) continue;
                id = id + "." + this._workerName;
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getHttpSession(String id) {
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            return (HttpSession)this._sessions.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession newHttpSession(HttpServletRequest request) {
        Session session = this.newSession(request);
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        MultiMap multiMap = __allSessions;
        synchronized (multiMap) {
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                this._sessions.put(session.getId(), session);
                __allSessions.add(session.getId(), session);
                if (this._sessions.size() > this._maxSessions) {
                    this._maxSessions = this._sessions.size();
                }
            }
        }
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
        for (int i = 0; i < this._sessionListeners.size(); ++i) {
            ((HttpSessionListener)this._sessionListeners.get(i)).sessionCreated(event);
        }
        if (this.getCrossContextSessionIDs()) {
            request.setAttribute(__NEW_SESSION_ID, (Object)session.getId());
        }
        return session;
    }

    public Cookie getSessionCookie(HttpSession session, boolean requestIsSecure) {
        if (this._handler.isUsingCookies()) {
            HttpOnlyCookie cookie = this._handler.getSessionManager().getHttpOnly() ? new HttpOnlyCookie(SessionManager.__SessionCookie, session.getId()) : new Cookie(SessionManager.__SessionCookie, session.getId());
            String domain = this._handler.getServletContext().getInitParameter("org.mortbay.jetty.servlet.SessionDomain");
            String maxAge = this._handler.getServletContext().getInitParameter("org.mortbay.jetty.servlet.MaxAge");
            String path = this._handler.getServletContext().getInitParameter("org.mortbay.jetty.servlet.SessionPath");
            if (path == null) {
                String string = path = this.getCrossContextSessionIDs() ? "/" : this._handler.getHttpContext().getContextPath();
            }
            if (path == null || path.length() == 0) {
                path = "/";
            }
            if (domain != null) {
                cookie.setDomain(domain);
            }
            if (maxAge != null) {
                cookie.setMaxAge(Integer.parseInt(maxAge));
            } else {
                cookie.setMaxAge(-1);
            }
            cookie.setSecure(requestIsSecure && this.getSecureCookies());
            cookie.setPath(path);
            return cookie;
        }
        return null;
    }

    protected abstract Session newSession(HttpServletRequest var1);

    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String workerName) {
        this._workerName = workerName;
    }

    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    public void setMaxInactiveInterval(int seconds) {
        this._dftMaxIdleSecs = seconds;
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > this._dftMaxIdleSecs * 100) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    public int getScavengePeriod() {
        return this._scavengePeriodMs / 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int seconds) {
        if (seconds == 0) {
            seconds = 60;
        }
        int old_period = this._scavengePeriodMs;
        int period = seconds * 1000;
        if (period > 60000) {
            period = 60000;
        }
        if (period < 1000) {
            period = 1000;
        }
        if (period != old_period) {
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                this._scavengePeriodMs = period;
                if (this._scavenger != null) {
                    this._scavenger.interrupt();
                }
            }
        }
    }

    public boolean getHttpOnly() {
        return this._httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this._httpOnly = httpOnly;
    }

    public boolean getSecureCookies() {
        return this._secureCookies;
    }

    public void setSecureCookies(boolean secureCookies) {
        this._secureCookies = secureCookies;
    }

    public boolean isInvalidateGlobal() {
        return this._invalidateGlobal;
    }

    public void setInvalidateGlobal(boolean global) {
        this._invalidateGlobal = global;
    }

    public void addEventListener(EventListener listener) throws IllegalArgumentException {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.add(listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners.add(listener);
        }
    }

    public void removeEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.remove(listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners.remove(listener);
        }
    }

    public boolean isStarted() {
        return this._scavenger != null;
    }

    public void start() throws Exception {
        if (this._random == null) {
            log.debug((Object)"New random session seed");
            this._random = new Random();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing random session key: " + this._random));
        }
        this._random.nextLong();
        if (this._sessions == null) {
            this._sessions = new HashMap();
        }
        if (this._scavenger == null) {
            this._scavenger = new SessionScavenger();
            this._scavenger.start();
        }
    }

    public void stop() {
        ArrayList sessions = new ArrayList(this._sessions.values());
        Iterator i = sessions.iterator();
        while (i.hasNext()) {
            Session session = (Session)i.next();
            session.invalidate();
        }
        this._sessions.clear();
        SessionScavenger scavenger = this._scavenger;
        this._scavenger = null;
        if (scavenger != null) {
            scavenger.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        try {
            if (this._handler == null) {
                return;
            }
            ClassLoader loader = this._handler.getClassLoader();
            if (loader != null) {
                thread.setContextClassLoader(loader);
            }
            long now = System.currentTimeMillis();
            Object stale = null;
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                Iterator i = this._sessions.values().iterator();
                while (i.hasNext()) {
                    Session session = (Session)i.next();
                    long idleTime = session._maxIdleMs;
                    if (idleTime <= 0L || session._accessed + idleTime >= now) continue;
                    stale = LazyList.add(stale, session);
                }
            }
            int i = LazyList.size(stale);
            while (i-- > 0) {
                Session session = (Session)LazyList.get(stale, i);
                long idleTime = session._maxIdleMs;
                if (idleTime <= 0L || session._accessed + idleTime >= System.currentTimeMillis()) continue;
                session.invalidate();
                int nbsess = this._sessions.size();
                if (nbsess >= this._minSessions) continue;
                this._minSessions = nbsess;
            }
        }
        finally {
            thread.setContextClassLoader(old_loader);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract class Session
    implements SessionManager.Session {
        Map _values;
        boolean _invalid = false;
        boolean _newSession = true;
        long _created;
        long _accessed = this._created = System.currentTimeMillis();
        long _maxIdleMs = AbstractSessionManager.access$400(AbstractSessionManager.this) * 1000;
        String _id;

        protected Session(HttpServletRequest request) {
            this._id = AbstractSessionManager.this.newSessionId(request, this._created);
            if (AbstractSessionManager.this._dftMaxIdleSecs >= 0) {
                this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs * 1000;
            }
        }

        protected abstract Map newAttributeMap();

        public void access() {
            this._newSession = false;
            this._accessed = System.currentTimeMillis();
        }

        public boolean isValid() {
            return !this._invalid;
        }

        public ServletContext getServletContext() {
            return AbstractSessionManager.this._handler.getServletContext();
        }

        public String getId() throws IllegalStateException {
            return this._id;
        }

        public long getCreationTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._created;
        }

        public long getLastAccessedTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._accessed;
        }

        public int getMaxInactiveInterval() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return (int)(this._maxIdleMs / 1000L);
        }

        public HttpSessionContext getSessionContext() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return SessionContext.NULL_IMPL;
        }

        public void setMaxInactiveInterval(int secs) {
            this._maxIdleMs = (long)secs * 1000L;
            if (this._maxIdleMs > 0L && this._maxIdleMs / 10L < (long)AbstractSessionManager.this._scavengePeriodMs) {
                AbstractSessionManager.this.setScavengePeriod((secs + 9) / 10);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() throws IllegalStateException {
            MultiMap multiMap;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalidate session " + this.getId() + " in " + AbstractSessionManager.this._handler.getHttpContext()));
            }
            try {
                Session session = this;
                synchronized (session) {
                    if (this._invalid) {
                        throw new IllegalStateException();
                    }
                    if (AbstractSessionManager.this._sessionListeners != null) {
                        HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
                        for (int i = 0; i < AbstractSessionManager.this._sessionListeners.size(); ++i) {
                            ((HttpSessionListener)AbstractSessionManager.this._sessionListeners.get(i)).sessionDestroyed(event);
                        }
                    }
                    if (this._values != null) {
                        Iterator iter = this._values.keySet().iterator();
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            Object value = this._values.get(key);
                            iter.remove();
                            this.unbindValue(key, value);
                            if (AbstractSessionManager.this._sessionAttributeListeners.size() <= 0) continue;
                            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
                            for (int i = 0; i < AbstractSessionManager.this._sessionAttributeListeners.size(); ++i) {
                                ((HttpSessionAttributeListener)AbstractSessionManager.this._sessionAttributeListeners.get(i)).attributeRemoved(event);
                            }
                        }
                    }
                }
                Object var9_9 = null;
                multiMap = __allSessions;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                MultiMap multiMap2 = __allSessions;
                synchronized (multiMap2) {
                    Map map = AbstractSessionManager.this._sessions;
                    synchronized (map) {
                        this._invalid = true;
                        AbstractSessionManager.this._sessions.remove(this.getId());
                        __allSessions.removeValue(this.getId(), this);
                        if (AbstractSessionManager.this.isInvalidateGlobal()) {
                            while (__allSessions.containsKey(this.getId())) {
                                Session session = (Session)__allSessions.getValue(this.getId(), 0);
                                session.invalidate();
                            }
                        }
                    }
                }
                throw throwable;
            }
            synchronized (multiMap) {
                Map map = AbstractSessionManager.this._sessions;
                synchronized (map) {
                    this._invalid = true;
                    AbstractSessionManager.this._sessions.remove(this.getId());
                    __allSessions.removeValue(this.getId(), this);
                    if (AbstractSessionManager.this.isInvalidateGlobal()) {
                        while (__allSessions.containsKey(this.getId())) {
                            Session session = (Session)__allSessions.getValue(this.getId(), 0);
                            session.invalidate();
                        }
                    }
                }
            }
        }

        public boolean isNew() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._newSession;
        }

        public synchronized Object getAttribute(String name) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return null;
            }
            return this._values.get(name);
        }

        public synchronized Enumeration getAttributeNames() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            List<Object> names = this._values == null ? Collections.EMPTY_LIST : new ArrayList(this._values.keySet());
            return Collections.enumeration(names);
        }

        public synchronized void setAttribute(String name, Object value) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                this._values = this.newAttributeMap();
            }
            Object oldValue = this._values.put(name, value);
            if (value == null || !value.equals(oldValue)) {
                this.unbindValue(name, oldValue);
                this.bindValue(name, value);
                if (AbstractSessionManager.this._sessionAttributeListeners.size() > 0) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue == null ? value : oldValue);
                    for (int i = 0; i < AbstractSessionManager.this._sessionAttributeListeners.size(); ++i) {
                        HttpSessionAttributeListener l = (HttpSessionAttributeListener)AbstractSessionManager.this._sessionAttributeListeners.get(i);
                        if (oldValue == null) {
                            l.attributeAdded(event);
                            continue;
                        }
                        if (value == null) {
                            l.attributeRemoved(event);
                            continue;
                        }
                        l.attributeReplaced(event);
                    }
                }
            }
        }

        public synchronized void removeAttribute(String name) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return;
            }
            Object old = this._values.remove(name);
            if (old != null) {
                this.unbindValue(name, old);
                if (AbstractSessionManager.this._sessionAttributeListeners.size() > 0) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, old);
                    for (int i = 0; i < AbstractSessionManager.this._sessionAttributeListeners.size(); ++i) {
                        HttpSessionAttributeListener l = (HttpSessionAttributeListener)AbstractSessionManager.this._sessionAttributeListeners.get(i);
                        l.attributeRemoved(event);
                    }
                }
            }
        }

        public Object getValue(String name) throws IllegalStateException {
            return this.getAttribute(name);
        }

        public synchronized String[] getValueNames() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return new String[0];
            }
            String[] a = new String[this._values.size()];
            return this._values.keySet().toArray(a);
        }

        public void putValue(String name, Object value) throws IllegalStateException {
            this.setAttribute(name, value);
        }

        public void removeValue(String name) throws IllegalStateException {
            this.removeAttribute(name);
        }

        private void bindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        private void unbindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }
    }

    class SessionScavenger
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int period = -1;
            try {
                while (AbstractSessionManager.this.isStarted()) {
                    try {
                        if (period != AbstractSessionManager.this._scavengePeriodMs) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Session scavenger period = " + AbstractSessionManager.this._scavengePeriodMs / 1000 + "s"));
                            }
                            period = AbstractSessionManager.this._scavengePeriodMs;
                        }
                        SessionScavenger.sleep(period > 1000 ? (long)period : 1000L);
                        AbstractSessionManager.this.scavenge();
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (Error e) {
                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                    }
                    catch (Exception e) {
                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                    }
                }
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                AbstractSessionManager.this._scavenger = null;
                log.debug((Object)"Session scavenger exited");
                throw throwable;
            }
            AbstractSessionManager.this._scavenger = null;
            log.debug((Object)"Session scavenger exited");
        }

        SessionScavenger() {
            super("SessionScavenger");
            this.setDaemon(true);
        }
    }
}

