/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.packetlogging.PacketLoggingService;

public class RTPConnectorUDPInputStream
extends RTPConnectorInputStream {
    private boolean setReceiveBufferSize = false;
    private final DatagramSocket socket;

    public RTPConnectorUDPInputStream(DatagramSocket socket) {
        this.socket = socket;
        if (socket != null) {
            this.closed = false;
            this.receiverThread = new Thread((Runnable)((Object)this));
            this.receiverThread.start();
        }
    }

    public synchronized void close() {
        this.closed = true;
        if (this.socket != null) {
            this.socket.close();
        }
    }

    protected void doLogPacket(DatagramPacket p) {
        if (this.socket.getLocalAddress() == null) {
            return;
        }
        if (this.socket instanceof MultiplexingDatagramSocket) {
            return;
        }
        PacketLoggingService packetLogging = LibJitsi.getPacketLoggingService();
        if (packetLogging != null) {
            packetLogging.logPacket(PacketLoggingService.ProtocolName.RTP, p.getAddress().getAddress(), p.getPort(), this.socket.getLocalAddress().getAddress(), this.socket.getLocalPort(), PacketLoggingService.TransportName.UDP, false, p.getData(), p.getOffset(), p.getLength());
        }
    }

    protected void receivePacket(DatagramPacket p) throws IOException {
        block3: {
            if (!this.setReceiveBufferSize) {
                this.setReceiveBufferSize = true;
                try {
                    this.socket.setReceiveBufferSize(65535);
                }
                catch (Throwable t) {
                    if (!(t instanceof ThreadDeath)) break block3;
                    throw (ThreadDeath)t;
                }
            }
        }
        this.socket.receive(p);
    }
}

