/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet;

import java.nio.charset.Charset;
import pl.mn.communicator.packet.HexDump;

public class GGUtils {
    private static final Charset CHARSET = Charset.forName("CP1250");

    public static String prettyBytesToString(byte[] bytes) {
        StringBuffer received = new StringBuffer();
        received.append("{");
        String dump = HexDump.hexDump(bytes);
        received.append(dump);
        received.append("}");
        return received.toString();
    }

    public static int byteToInt(byte[] buf) {
        return GGUtils.byteToInt(buf, 0);
    }

    public static int byteToInt(byte[] buf, int start) {
        int i = 0;
        int pos = start;
        int tmp = GGUtils.unsignedByteToInt(buf[pos++]) << 0;
        i += tmp;
        tmp = GGUtils.unsignedByteToInt(buf[pos++]) << 8;
        i += tmp;
        tmp = GGUtils.unsignedByteToInt(buf[pos++]) << 16;
        i += tmp;
        tmp = GGUtils.unsignedByteToInt(buf[pos++]) << 24;
        return i += tmp;
    }

    public static int byteToShort(byte[] buf, int start) {
        int i = 0;
        int pos = start;
        int tmp = GGUtils.unsignedByteToInt(buf[pos++]) << 0;
        i += tmp;
        tmp = GGUtils.unsignedByteToInt(buf[pos++]) << 8;
        return i += tmp;
    }

    public static long secondsToMillis(int seconds) {
        return (long)seconds * 1000L;
    }

    public static int millisToSeconds(long millis) {
        return (int)(millis / 1000L);
    }

    public static int unsignedByteToInt(byte i) {
        if (i < 0) {
            return (i & 0x7F) + 128;
        }
        return i;
    }

    public static byte[] intToByte(int buf) {
        byte[] toSend = new byte[4];
        toSend[3] = (byte)(buf >> 24 & 0xFF);
        toSend[2] = (byte)(buf >> 16 & 0xFF);
        toSend[1] = (byte)(buf >> 8 & 0xFF);
        toSend[0] = (byte)(buf & 0xFF);
        return toSend;
    }

    public static long unsignedIntToLong(int i) {
        long plus = 0L;
        plus -= (long)(i & Integer.MIN_VALUE);
        return (long)(i &= Integer.MAX_VALUE) + plus;
    }

    public static String byteToString(byte[] data, int startIndex) {
        return GGUtils.byteToString(data, startIndex, data.length - startIndex);
    }

    public static String bytezToString(byte[] data, int startIndex) {
        int offset;
        for (offset = startIndex; offset < data.length && data[offset] != 0; ++offset) {
        }
        return GGUtils.byteToString(data, startIndex, offset - startIndex);
    }

    public static String byteToString(byte[] data, int startIndex, int length) {
        return new String(data, startIndex, length, CHARSET);
    }

    public static byte[] stringToBytes(String string) {
        return string.getBytes(CHARSET);
    }

    public static byte[] convertIntToByteArray(int i) {
        byte[] bytes = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
        return bytes;
    }

    public static int getLoginHash(char[] password, int seed) {
        long y = seed;
        long x = 0L;
        for (int i = 0; i < password.length; ++i) {
            x = x & 0xFFFFFFFFFFFFFF00L | (long)password[i];
            int k = (int)(y ^= x);
            k = (int)((long)k + x);
            y = GGUtils.unsignedIntToLong(k);
            k = (int)x;
            x = GGUtils.unsignedIntToLong(k <<= 8);
            y ^= x;
            k = (int)x;
            x = GGUtils.unsignedIntToLong(k <<= 8);
            k = (int)y;
            k = (int)((long)k - x);
            y = GGUtils.unsignedIntToLong(k);
            k = (int)x;
            x = GGUtils.unsignedIntToLong(k <<= 8);
            long z = (y ^= x) & 0x1FL;
            y = GGUtils.unsignedIntToLong((int)(y << (int)z | y >> (int)(32L - z)));
        }
        return (int)y;
    }
}

