/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.loc.DirInfoCmd;
import net.kano.joscar.snaccmd.loc.LocRightsCmd;
import net.kano.joscar.snaccmd.loc.SetDirAck;
import net.kano.joscar.snaccmd.loc.SetInterestsAck;
import net.kano.joscar.snaccmd.loc.UserInfoCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLocCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList((Object[])new CmdType[]{new CmdType(2, 3), new CmdType(2, 6), new CmdType(2, 12), new CmdType(2, 16), new CmdType(2, 10)});

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket packet) {
        if (packet.getFamily() != 2) {
            return null;
        }
        int command = packet.getCommand();
        if (command == 3) {
            return new LocRightsCmd(packet);
        }
        if (command == 6) {
            return new UserInfoCmd(packet);
        }
        if (command == 12) {
            return new DirInfoCmd(packet);
        }
        if (command == 16) {
            return new SetInterestsAck(packet);
        }
        if (command == 10) {
            return new SetDirAck(packet);
        }
        return null;
    }
}

