/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network.event;

import java.util.Date;
import java.util.EventObject;

public class SessionEvent
extends EventObject {
    private static final long serialVersionUID = -128672051097761320L;
    private final String to;
    private final String from;
    protected String message;
    private final long timestamp;
    private long status = 0L;

    public SessionEvent(Object source) {
        this(source, null, null, null, 0L);
    }

    public SessionEvent(Object source, String to, String from, String message) {
        this(source, to, from, message, 0L);
    }

    public SessionEvent(Object source, String to, String from, String message, long timestampInMillis) {
        super(source);
        this.to = to;
        this.from = from;
        this.message = message;
        this.timestamp = timestampInMillis;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getTimestamp() {
        return new Date(this.timestamp);
    }

    public long getStatus() {
        return this.status;
    }

    public void setStatus(long s) {
        this.status = s;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getCanonicalName()).append(" to:").append(this.to).append(" from:").append(this.from).append(" message:").append(this.message).append(" timestamp:").append(this.timestamp).append(" status:").append(this.status);
        return sb.toString();
    }
}

