/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.Accept;
import gov.nist.javax.sip.header.AcceptEncoding;
import gov.nist.javax.sip.header.AcceptLanguage;
import gov.nist.javax.sip.header.AlertInfo;
import gov.nist.javax.sip.header.Allow;
import gov.nist.javax.sip.header.AllowEvents;
import gov.nist.javax.sip.header.AuthenticationInfo;
import gov.nist.javax.sip.header.Authorization;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.CallInfo;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.ContentDisposition;
import gov.nist.javax.sip.header.ContentEncoding;
import gov.nist.javax.sip.header.ContentLanguage;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.ErrorInfo;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.Expires;
import gov.nist.javax.sip.header.ExtensionHeaderImpl;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.InReplyTo;
import gov.nist.javax.sip.header.MaxForwards;
import gov.nist.javax.sip.header.MimeVersion;
import gov.nist.javax.sip.header.MinExpires;
import gov.nist.javax.sip.header.Organization;
import gov.nist.javax.sip.header.Priority;
import gov.nist.javax.sip.header.ProxyAuthenticate;
import gov.nist.javax.sip.header.ProxyAuthorization;
import gov.nist.javax.sip.header.ProxyRequire;
import gov.nist.javax.sip.header.RAck;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.Reason;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.ReferTo;
import gov.nist.javax.sip.header.ReplyTo;
import gov.nist.javax.sip.header.Require;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.SIPDateHeader;
import gov.nist.javax.sip.header.SIPETag;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.SIPHeaderList;
import gov.nist.javax.sip.header.SIPIfMatch;
import gov.nist.javax.sip.header.Server;
import gov.nist.javax.sip.header.Subject;
import gov.nist.javax.sip.header.SubscriptionState;
import gov.nist.javax.sip.header.Supported;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Unsupported;
import gov.nist.javax.sip.header.UserAgent;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.WWWAuthenticate;
import gov.nist.javax.sip.header.Warning;
import gov.nist.javax.sip.header.extensions.MinSE;
import gov.nist.javax.sip.header.extensions.ReferredBy;
import gov.nist.javax.sip.header.extensions.Replaces;
import gov.nist.javax.sip.header.extensions.SessionExpires;
import gov.nist.javax.sip.header.ims.PAccessNetworkInfo;
import gov.nist.javax.sip.header.ims.PAccessNetworkInfoHeader;
import gov.nist.javax.sip.header.ims.PAssertedIdentity;
import gov.nist.javax.sip.header.ims.PAssertedIdentityHeader;
import gov.nist.javax.sip.header.ims.PAssociatedURI;
import gov.nist.javax.sip.header.ims.PAssociatedURIHeader;
import gov.nist.javax.sip.header.ims.PCalledPartyID;
import gov.nist.javax.sip.header.ims.PCalledPartyIDHeader;
import gov.nist.javax.sip.header.ims.PChargingFunctionAddresses;
import gov.nist.javax.sip.header.ims.PChargingFunctionAddressesHeader;
import gov.nist.javax.sip.header.ims.PChargingVector;
import gov.nist.javax.sip.header.ims.PChargingVectorHeader;
import gov.nist.javax.sip.header.ims.PMediaAuthorization;
import gov.nist.javax.sip.header.ims.PMediaAuthorizationHeader;
import gov.nist.javax.sip.header.ims.PPreferredIdentity;
import gov.nist.javax.sip.header.ims.PPreferredIdentityHeader;
import gov.nist.javax.sip.header.ims.PVisitedNetworkID;
import gov.nist.javax.sip.header.ims.PVisitedNetworkIDHeader;
import gov.nist.javax.sip.header.ims.Path;
import gov.nist.javax.sip.header.ims.PathHeader;
import gov.nist.javax.sip.header.ims.Privacy;
import gov.nist.javax.sip.header.ims.PrivacyHeader;
import gov.nist.javax.sip.header.ims.SecurityClient;
import gov.nist.javax.sip.header.ims.SecurityClientHeader;
import gov.nist.javax.sip.header.ims.SecurityServer;
import gov.nist.javax.sip.header.ims.SecurityServerHeader;
import gov.nist.javax.sip.header.ims.SecurityVerify;
import gov.nist.javax.sip.header.ims.SecurityVerifyHeader;
import gov.nist.javax.sip.header.ims.ServiceRoute;
import gov.nist.javax.sip.header.ims.ServiceRouteHeader;
import gov.nist.javax.sip.parser.StringMsgParser;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.sip.InvalidArgumentException;
import javax.sip.address.Address;
import javax.sip.address.URI;
import javax.sip.header.AcceptEncodingHeader;
import javax.sip.header.AcceptHeader;
import javax.sip.header.AcceptLanguageHeader;
import javax.sip.header.AlertInfoHeader;
import javax.sip.header.AllowEventsHeader;
import javax.sip.header.AllowHeader;
import javax.sip.header.AuthenticationInfoHeader;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.CallInfoHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentDispositionHeader;
import javax.sip.header.ContentEncodingHeader;
import javax.sip.header.ContentLanguageHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.DateHeader;
import javax.sip.header.ErrorInfoHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.ExtensionHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.InReplyToHeader;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.MimeVersionHeader;
import javax.sip.header.MinExpiresHeader;
import javax.sip.header.OrganizationHeader;
import javax.sip.header.PriorityHeader;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.ProxyAuthorizationHeader;
import javax.sip.header.ProxyRequireHeader;
import javax.sip.header.RAckHeader;
import javax.sip.header.RSeqHeader;
import javax.sip.header.ReasonHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.ReferToHeader;
import javax.sip.header.ReplyToHeader;
import javax.sip.header.RequireHeader;
import javax.sip.header.RetryAfterHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.SIPETagHeader;
import javax.sip.header.SIPIfMatchHeader;
import javax.sip.header.ServerHeader;
import javax.sip.header.SubjectHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.SupportedHeader;
import javax.sip.header.TimeStampHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.UnsupportedHeader;
import javax.sip.header.UserAgentHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.header.WarningHeader;

public class HeaderFactoryImpl
implements HeaderFactory {
    public AcceptEncodingHeader createAcceptEncodingHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("the encoding parameter is null");
        }
        AcceptEncoding acceptEncoding = new AcceptEncoding();
        acceptEncoding.setEncoding(string);
        return acceptEncoding;
    }

    public AcceptHeader createAcceptHeader(String string, String string2) throws ParseException {
        if (string == null || string2 == null) {
            throw new NullPointerException("contentType or subtype is null ");
        }
        Accept accept = new Accept();
        accept.setContentType(string);
        accept.setContentSubType(string2);
        return accept;
    }

    public AcceptLanguageHeader createAcceptLanguageHeader(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("null arg");
        }
        AcceptLanguage acceptLanguage = new AcceptLanguage();
        acceptLanguage.setAcceptLanguage(locale);
        return acceptLanguage;
    }

    public AlertInfoHeader createAlertInfoHeader(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("null arg alertInfo");
        }
        AlertInfo alertInfo = new AlertInfo();
        alertInfo.setAlertInfo(uRI);
        return alertInfo;
    }

    public AllowEventsHeader createAllowEventsHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg eventType");
        }
        AllowEvents allowEvents = new AllowEvents();
        allowEvents.setEventType(string);
        return allowEvents;
    }

    public AllowHeader createAllowHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg method");
        }
        Allow allow = new Allow();
        allow.setMethod(string);
        return allow;
    }

    public AuthenticationInfoHeader createAuthenticationInfoHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg response");
        }
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        authenticationInfo.setResponse(string);
        return authenticationInfo;
    }

    public AuthorizationHeader createAuthorizationHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg scheme ");
        }
        Authorization authorization = new Authorization();
        authorization.setScheme(string);
        return authorization;
    }

    public CSeqHeader createCSeqHeader(long l, String string) throws ParseException, InvalidArgumentException {
        if (l < 0L) {
            throw new InvalidArgumentException("bad arg " + l);
        }
        if (string == null) {
            throw new NullPointerException("null arg method");
        }
        CSeq cSeq = new CSeq();
        cSeq.setMethod(string);
        cSeq.setSeqNumber(l);
        return cSeq;
    }

    public CSeqHeader createCSeqHeader(int n, String string) throws ParseException, InvalidArgumentException {
        return this.createCSeqHeader((long)n, string);
    }

    public CallIdHeader createCallIdHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg callId");
        }
        CallID callID = new CallID();
        callID.setCallId(string);
        return callID;
    }

    public CallInfoHeader createCallInfoHeader(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("null arg callInfo");
        }
        CallInfo callInfo = new CallInfo();
        callInfo.setInfo(uRI);
        return callInfo;
    }

    public ContactHeader createContactHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null arg address");
        }
        Contact contact = new Contact();
        contact.setAddress(address);
        return contact;
    }

    public ContactHeader createContactHeader() {
        Contact contact = new Contact();
        contact.setWildCardFlag(true);
        contact.setExpires(0);
        return contact;
    }

    public ContentDispositionHeader createContentDispositionHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg contentDisposition");
        }
        ContentDisposition contentDisposition = new ContentDisposition();
        contentDisposition.setDispositionType(string);
        return contentDisposition;
    }

    public ContentEncodingHeader createContentEncodingHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null encoding");
        }
        ContentEncoding contentEncoding = new ContentEncoding();
        contentEncoding.setEncoding(string);
        return contentEncoding;
    }

    public ContentLanguageHeader createContentLanguageHeader(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("null arg contentLanguage");
        }
        ContentLanguage contentLanguage = new ContentLanguage();
        contentLanguage.setContentLanguage(locale);
        return contentLanguage;
    }

    public ContentLengthHeader createContentLengthHeader(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("bad contentLength");
        }
        ContentLength contentLength = new ContentLength();
        contentLength.setContentLength(n);
        return contentLength;
    }

    public ContentTypeHeader createContentTypeHeader(String string, String string2) throws ParseException {
        if (string == null || string2 == null) {
            throw new NullPointerException("null contentType or subType");
        }
        ContentType contentType = new ContentType();
        contentType.setContentType(string);
        contentType.setContentSubType(string2);
        return contentType;
    }

    public DateHeader createDateHeader(Calendar calendar) {
        SIPDateHeader sIPDateHeader = new SIPDateHeader();
        if (calendar == null) {
            throw new NullPointerException("null date");
        }
        sIPDateHeader.setDate(calendar);
        return sIPDateHeader;
    }

    public EventHeader createEventHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null eventType");
        }
        Event event = new Event();
        event.setEventType(string);
        return event;
    }

    public ExpiresHeader createExpiresHeader(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("bad value " + n);
        }
        Expires expires = new Expires();
        expires.setExpires(n);
        return expires;
    }

    public ExtensionHeader createExtensionHeader(String string, String string2) throws ParseException {
        if (string == null) {
            throw new NullPointerException("bad name");
        }
        ExtensionHeaderImpl extensionHeaderImpl = new ExtensionHeaderImpl();
        extensionHeaderImpl.setName(string);
        extensionHeaderImpl.setValue(string2);
        return extensionHeaderImpl;
    }

    public FromHeader createFromHeader(Address address, String string) throws ParseException {
        if (address == null) {
            throw new NullPointerException("null address arg");
        }
        From from = new From();
        from.setAddress(address);
        if (string != null) {
            from.setTag(string);
        }
        return from;
    }

    public InReplyToHeader createInReplyToHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null callId arg");
        }
        InReplyTo inReplyTo = new InReplyTo();
        inReplyTo.setCallId(string);
        return inReplyTo;
    }

    public MaxForwardsHeader createMaxForwardsHeader(int n) throws InvalidArgumentException {
        if (n < 0 || n > 255) {
            throw new InvalidArgumentException("bad maxForwards arg " + n);
        }
        MaxForwards maxForwards = new MaxForwards();
        maxForwards.setMaxForwards(n);
        return maxForwards;
    }

    public MimeVersionHeader createMimeVersionHeader(int n, int n2) throws InvalidArgumentException {
        if (n < 0 || n2 < 0) {
            throw new InvalidArgumentException("bad major/minor version");
        }
        MimeVersion mimeVersion = new MimeVersion();
        mimeVersion.setMajorVersion(n);
        mimeVersion.setMinorVersion(n2);
        return mimeVersion;
    }

    public MinExpiresHeader createMinExpiresHeader(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("bad minExpires " + n);
        }
        MinExpires minExpires = new MinExpires();
        minExpires.setExpires(n);
        return minExpires;
    }

    public ExtensionHeader createMinSEHeader(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("bad value " + n);
        }
        MinSE minSE = new MinSE();
        minSE.setExpires(n);
        return minSE;
    }

    public OrganizationHeader createOrganizationHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("bad organization arg");
        }
        Organization organization = new Organization();
        organization.setOrganization(string);
        return organization;
    }

    public PriorityHeader createPriorityHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("bad priority arg");
        }
        Priority priority = new Priority();
        priority.setPriority(string);
        return priority;
    }

    public ProxyAuthenticateHeader createProxyAuthenticateHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("bad scheme arg");
        }
        ProxyAuthenticate proxyAuthenticate = new ProxyAuthenticate();
        proxyAuthenticate.setScheme(string);
        return proxyAuthenticate;
    }

    public ProxyAuthorizationHeader createProxyAuthorizationHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("bad scheme arg");
        }
        ProxyAuthorization proxyAuthorization = new ProxyAuthorization();
        proxyAuthorization.setScheme(string);
        return proxyAuthorization;
    }

    public ProxyRequireHeader createProxyRequireHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("bad optionTag arg");
        }
        ProxyRequire proxyRequire = new ProxyRequire();
        proxyRequire.setOptionTag(string);
        return proxyRequire;
    }

    public RAckHeader createRAckHeader(long l, long l2, String string) throws InvalidArgumentException, ParseException {
        if (string == null) {
            throw new NullPointerException("Bad method");
        }
        if (l2 < 0L || l < 0L) {
            throw new InvalidArgumentException("bad cseq/rseq arg");
        }
        RAck rAck = new RAck();
        rAck.setMethod(string);
        rAck.setCSequenceNumber(l2);
        rAck.setRSequenceNumber(l);
        return rAck;
    }

    public RAckHeader createRAckHeader(int n, int n2, String string) throws InvalidArgumentException, ParseException {
        return this.createRAckHeader((long)n, (long)n2, string);
    }

    public RSeqHeader createRSeqHeader(int n) throws InvalidArgumentException {
        return this.createRSeqHeader((long)n);
    }

    public RSeqHeader createRSeqHeader(long l) throws InvalidArgumentException {
        if (l < 0L) {
            throw new InvalidArgumentException("invalid sequenceNumber arg " + l);
        }
        RSeq rSeq = new RSeq();
        rSeq.setSeqNumber(l);
        return rSeq;
    }

    public ReasonHeader createReasonHeader(String string, int n, String string2) throws InvalidArgumentException, ParseException {
        if (string == null) {
            throw new NullPointerException("bad protocol arg");
        }
        if (n < 0) {
            throw new InvalidArgumentException("bad cause");
        }
        Reason reason = new Reason();
        reason.setProtocol(string);
        reason.setCause(n);
        reason.setText(string2);
        return reason;
    }

    public RecordRouteHeader createRecordRouteHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("Null argument!");
        }
        RecordRoute recordRoute = new RecordRoute();
        recordRoute.setAddress(address);
        return recordRoute;
    }

    public ReplyToHeader createReplyToHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address");
        }
        ReplyTo replyTo = new ReplyTo();
        replyTo.setAddress(address);
        return replyTo;
    }

    public RequireHeader createRequireHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null optionTag");
        }
        Require require = new Require();
        require.setOptionTag(string);
        return require;
    }

    public RetryAfterHeader createRetryAfterHeader(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("bad retryAfter arg");
        }
        RetryAfter retryAfter = new RetryAfter();
        retryAfter.setRetryAfter(n);
        return retryAfter;
    }

    public RouteHeader createRouteHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address arg");
        }
        Route route = new Route();
        route.setAddress(address);
        return route;
    }

    public ServerHeader createServerHeader(List list) throws ParseException {
        if (list == null) {
            throw new NullPointerException("null productList arg");
        }
        Server server = new Server();
        server.setProduct(list);
        return server;
    }

    public SubjectHeader createSubjectHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null subject arg");
        }
        Subject subject = new Subject();
        subject.setSubject(string);
        return subject;
    }

    public SubscriptionStateHeader createSubscriptionStateHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null subscriptionState arg");
        }
        SubscriptionState subscriptionState = new SubscriptionState();
        subscriptionState.setState(string);
        return subscriptionState;
    }

    public SupportedHeader createSupportedHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null optionTag arg");
        }
        Supported supported = new Supported();
        supported.setOptionTag(string);
        return supported;
    }

    public TimeStampHeader createTimeStampHeader(float f) throws InvalidArgumentException {
        if (f < 0.0f) {
            throw new IllegalArgumentException("illegal timeStamp");
        }
        TimeStamp timeStamp = new TimeStamp();
        timeStamp.setTimeStamp(f);
        return timeStamp;
    }

    public ToHeader createToHeader(Address address, String string) throws ParseException {
        if (address == null) {
            throw new NullPointerException("null address");
        }
        To to = new To();
        to.setAddress(address);
        if (string != null) {
            to.setTag(string);
        }
        return to;
    }

    public UnsupportedHeader createUnsupportedHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException(string);
        }
        Unsupported unsupported = new Unsupported();
        unsupported.setOptionTag(string);
        return unsupported;
    }

    public UserAgentHeader createUserAgentHeader(List list) throws ParseException {
        if (list == null) {
            throw new NullPointerException("null user agent");
        }
        UserAgent userAgent = new UserAgent();
        userAgent.setProduct(list);
        return userAgent;
    }

    public ViaHeader createViaHeader(String string, int n, String string2, String string3) throws ParseException, InvalidArgumentException {
        if (string == null || string2 == null) {
            throw new NullPointerException("null arg");
        }
        Via via = new Via();
        if (string3 != null) {
            via.setBranch(string3);
        }
        if (string.indexOf(58) >= 0 && string.indexOf(91) < 0) {
            string = '[' + string + ']';
        }
        via.setHost(string);
        via.setPort(n);
        via.setTransport(string2);
        return via;
    }

    public WWWAuthenticateHeader createWWWAuthenticateHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null scheme");
        }
        WWWAuthenticate wWWAuthenticate = new WWWAuthenticate();
        wWWAuthenticate.setScheme(string);
        return wWWAuthenticate;
    }

    public WarningHeader createWarningHeader(String string, int n, String string2) throws ParseException, InvalidArgumentException {
        if (string == null) {
            throw new NullPointerException("null arg");
        }
        Warning warning = new Warning();
        warning.setAgent(string);
        warning.setCode(n);
        warning.setText(string2);
        return warning;
    }

    public ErrorInfoHeader createErrorInfoHeader(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("null arg");
        }
        return new ErrorInfo((GenericURI)uRI);
    }

    public Header createHeader(String string, String string2) throws ParseException {
        if (string == null) {
            throw new NullPointerException("header name is null");
        }
        StringMsgParser stringMsgParser = new StringMsgParser();
        String string3 = string + ":" + string2;
        SIPHeader sIPHeader = stringMsgParser.parseSIPHeader(string3);
        if (sIPHeader instanceof SIPHeaderList) {
            if (((SIPHeaderList)sIPHeader).size() > 1) {
                throw new ParseException("Only singleton allowed " + string3, 0);
            }
            if (((SIPHeaderList)sIPHeader).size() == 0) {
                try {
                    return (Header)((SIPHeaderList)sIPHeader).getMyClass().newInstance();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    return null;
                }
            }
            return ((SIPHeaderList)sIPHeader).getFirst();
        }
        return sIPHeader;
    }

    public List createHeaders(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg!");
        }
        StringMsgParser stringMsgParser = new StringMsgParser();
        SIPHeader sIPHeader = stringMsgParser.parseSIPHeader(string);
        if (sIPHeader instanceof SIPHeaderList) {
            return (SIPHeaderList)sIPHeader;
        }
        throw new ParseException("List of headers of this type is not allowed in a message", 0);
    }

    public ReferToHeader createReferToHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        ReferTo referTo = new ReferTo();
        referTo.setAddress(address);
        return referTo;
    }

    public ExtensionHeader createReferredByHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        ReferredBy referredBy = new ReferredBy();
        referredBy.setAddress(address);
        return referredBy;
    }

    public ExtensionHeader createReplacesHeader(String string, String string2, String string3) throws ParseException {
        Replaces replaces = new Replaces();
        replaces.setCallId(string);
        replaces.setFromTag(string3);
        replaces.setToTag(string2);
        return replaces;
    }

    public SIPETagHeader createSIPETagHeader(String string) throws ParseException {
        return new SIPETag(string);
    }

    public SIPIfMatchHeader createSIPIfMatchHeader(String string) throws ParseException {
        return new SIPIfMatch(string);
    }

    public PAccessNetworkInfoHeader createPAccessNetworkInfoHeader() {
        PAccessNetworkInfo pAccessNetworkInfo = new PAccessNetworkInfo();
        return pAccessNetworkInfo;
    }

    public PAssertedIdentityHeader createPAssertedIdentityHeader(Address address) throws NullPointerException, ParseException {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        PAssertedIdentity pAssertedIdentity = new PAssertedIdentity();
        pAssertedIdentity.setAddress(address);
        return pAssertedIdentity;
    }

    public PAssociatedURIHeader createPAssociatedURIHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null associatedURI!");
        }
        PAssociatedURI pAssociatedURI = new PAssociatedURI();
        pAssociatedURI.setAddress(address);
        return pAssociatedURI;
    }

    public PCalledPartyIDHeader createPCalledPartyIDHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        PCalledPartyID pCalledPartyID = new PCalledPartyID();
        pCalledPartyID.setAddress(address);
        return pCalledPartyID;
    }

    public PChargingFunctionAddressesHeader createPChargingFunctionAddressesHeader() {
        PChargingFunctionAddresses pChargingFunctionAddresses = new PChargingFunctionAddresses();
        return pChargingFunctionAddresses;
    }

    public PChargingVectorHeader createChargingVectorHeader(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null icid arg!");
        }
        PChargingVector pChargingVector = new PChargingVector();
        pChargingVector.setICID(string);
        return pChargingVector;
    }

    public PMediaAuthorizationHeader createPMediaAuthorizationHeader(String string) throws InvalidArgumentException, ParseException {
        if (string == null || string == "") {
            throw new InvalidArgumentException("The Media-Authorization-Token parameter is null or empty");
        }
        PMediaAuthorization pMediaAuthorization = new PMediaAuthorization();
        pMediaAuthorization.setMediaAuthorizationToken(string);
        return pMediaAuthorization;
    }

    public PPreferredIdentityHeader createPPreferredIdentityHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        PPreferredIdentity pPreferredIdentity = new PPreferredIdentity();
        pPreferredIdentity.setAddress(address);
        return pPreferredIdentity;
    }

    public PVisitedNetworkIDHeader createPVisitedNetworkIDHeader() {
        PVisitedNetworkID pVisitedNetworkID = new PVisitedNetworkID();
        return pVisitedNetworkID;
    }

    public PathHeader createPathHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        Path path = new Path();
        path.setAddress(address);
        return path;
    }

    public PrivacyHeader createPrivacyHeader(String string) {
        if (string == null) {
            throw new NullPointerException("null privacyType arg");
        }
        Privacy privacy = new Privacy(string);
        return privacy;
    }

    public ServiceRouteHeader createServiceRouteHeader(Address address) {
        if (address == null) {
            throw new NullPointerException("null address!");
        }
        ServiceRoute serviceRoute = new ServiceRoute();
        serviceRoute.setAddress(address);
        return serviceRoute;
    }

    public SecurityServerHeader createSecurityServerHeader() {
        SecurityServer securityServer = new SecurityServer();
        return securityServer;
    }

    public SecurityClientHeader createSecurityClientHeader() {
        SecurityClient securityClient = new SecurityClient();
        return securityClient;
    }

    public SecurityVerifyHeader createSecurityVerifyHeader() {
        SecurityVerify securityVerify = new SecurityVerify();
        return securityVerify;
    }

    public ExtensionHeader createSessionExpiresHeader(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("bad value " + n);
        }
        SessionExpires sessionExpires = new SessionExpires();
        sessionExpires.setExpires(n);
        return sessionExpires;
    }
}

