/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import socks.Proxy;
import socks.Socks5DatagramSocket;
import socks.server.ServerAuthenticator;

class UDPRelayServer
implements Runnable {
    DatagramSocket client_sock;
    DatagramSocket remote_sock;
    Socket controlConnection;
    int relayPort;
    InetAddress relayIP;
    Thread pipe_thread1;
    Thread pipe_thread2;
    Thread master_thread;
    ServerAuthenticator auth;
    long lastReadTime;
    static PrintStream log = null;
    static Proxy proxy = null;
    static int datagramSize = 65535;
    static int iddleTimeout = 180000;

    public UDPRelayServer(InetAddress clientIP, int clientPort, Thread master_thread, Socket controlConnection, ServerAuthenticator auth) throws IOException {
        this.master_thread = master_thread;
        this.controlConnection = controlConnection;
        this.auth = auth;
        this.client_sock = new Socks5DatagramSocket(true, auth.getUdpEncapsulation(), clientIP, clientPort);
        this.relayPort = this.client_sock.getLocalPort();
        this.relayIP = this.client_sock.getLocalAddress();
        if (this.relayIP.getHostAddress().equals("0.0.0.0")) {
            this.relayIP = InetAddress.getLocalHost();
        }
        this.remote_sock = proxy == null ? new DatagramSocket() : new Socks5DatagramSocket(proxy, 0, null);
    }

    public static void setTimeout(int timeout) {
        iddleTimeout = timeout;
    }

    public static void setDatagramSize(int size) {
        datagramSize = size;
    }

    public int getRelayPort() {
        return this.relayPort;
    }

    public InetAddress getRelayIP() {
        return this.relayIP;
    }

    public void start() throws IOException {
        this.remote_sock.setSoTimeout(iddleTimeout);
        this.client_sock.setSoTimeout(iddleTimeout);
        UDPRelayServer.log("Starting UDP relay server on " + this.relayIP + ":" + this.relayPort);
        UDPRelayServer.log("Remote socket " + this.remote_sock.getLocalAddress() + ":" + this.remote_sock.getLocalPort());
        this.pipe_thread1 = new Thread((Runnable)this, "pipe1");
        this.pipe_thread2 = new Thread((Runnable)this, "pipe2");
        this.lastReadTime = System.currentTimeMillis();
        this.pipe_thread1.start();
        this.pipe_thread2.start();
    }

    public synchronized void stop() {
        this.master_thread = null;
        this.controlConnection = null;
        this.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (Thread.currentThread().getName().equals("pipe1")) {
                this.pipe(this.remote_sock, this.client_sock, false);
            } else {
                this.pipe(this.client_sock, this.remote_sock, true);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.abort();
            UDPRelayServer.log("UDP Pipe thread " + Thread.currentThread().getName() + " stopped.");
        }
    }

    private synchronized void abort() {
        if (this.pipe_thread1 == null) {
            return;
        }
        UDPRelayServer.log("Aborting UDP Relay Server");
        this.remote_sock.close();
        this.client_sock.close();
        if (this.controlConnection != null) {
            try {
                this.controlConnection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.master_thread != null) {
            this.master_thread.interrupt();
        }
        this.pipe_thread1.interrupt();
        this.pipe_thread2.interrupt();
        this.pipe_thread1 = null;
    }

    private static void log(String s) {
        if (log != null) {
            log.println(s);
            log.flush();
        }
    }

    private void pipe(DatagramSocket from, DatagramSocket to, boolean out) throws IOException {
        byte[] data = new byte[datagramSize];
        DatagramPacket dp = new DatagramPacket(data, data.length);
        while (true) {
            block6: {
                try {
                    from.receive(dp);
                    this.lastReadTime = System.currentTimeMillis();
                    if (this.auth.checkRequest(dp, out)) {
                        to.send(dp);
                    }
                }
                catch (UnknownHostException uhe) {
                    UDPRelayServer.log("Dropping datagram for unknown host");
                }
                catch (InterruptedIOException iioe) {
                    if (iddleTimeout == 0) {
                        return;
                    }
                    long timeSinceRead = System.currentTimeMillis() - this.lastReadTime;
                    if (timeSinceRead < (long)(iddleTimeout - 100)) break block6;
                    return;
                }
            }
            dp.setLength(data.length);
        }
    }
}

