/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import socks.Proxy;
import socks.ProxyMessage;
import socks.Socks5Message;
import socks.Socks5Proxy;
import socks.SocksException;
import socks.UDPEncapsulation;

public class Socks5DatagramSocket
extends DatagramSocket {
    InetAddress relayIP;
    int relayPort;
    Socks5Proxy proxy;
    private boolean server_mode = false;
    UDPEncapsulation encapsulation;

    public Socks5DatagramSocket() throws SocksException, IOException {
        this(Proxy.defaultProxy, 0, null);
    }

    public Socks5DatagramSocket(int port) throws SocksException, IOException {
        this(Proxy.defaultProxy, port, null);
    }

    public Socks5DatagramSocket(int port, InetAddress ip) throws SocksException, IOException {
        this(Proxy.defaultProxy, port, ip);
    }

    public Socks5DatagramSocket(Proxy p, int port, InetAddress ip) throws SocksException, IOException {
        super(port, ip);
        if (p == null) {
            throw new SocksException(65536);
        }
        if (!(p instanceof Socks5Proxy)) {
            throw new SocksException(-1, "Datagram Socket needs Proxy version 5");
        }
        if (p.chainProxy != null) {
            throw new SocksException(393216, "Datagram Sockets do not support proxy chaining.");
        }
        this.proxy = (Socks5Proxy)p.copy();
        ProxyMessage msg = this.proxy.udpAssociate(super.getLocalAddress(), super.getLocalPort());
        this.relayIP = msg.ip;
        if (this.relayIP.getHostAddress().equals("0.0.0.0")) {
            this.relayIP = this.proxy.proxyIP;
        }
        this.relayPort = msg.port;
        this.encapsulation = this.proxy.udp_encapsulation;
    }

    Socks5DatagramSocket(boolean server_mode, UDPEncapsulation encapsulation, InetAddress relayIP, int relayPort) throws IOException {
        this.server_mode = server_mode;
        this.relayIP = relayIP;
        this.relayPort = relayPort;
        this.encapsulation = encapsulation;
        this.proxy = null;
    }

    public void send(DatagramPacket dp) throws IOException {
        if (!this.server_mode && this.proxy.isDirect(dp.getAddress())) {
            super.send(dp);
            return;
        }
        byte[] head = this.formHeader(dp.getAddress(), dp.getPort());
        byte[] buf = new byte[head.length + dp.getLength()];
        byte[] data = dp.getData();
        System.arraycopy(head, 0, buf, 0, head.length);
        System.arraycopy(data, 0, buf, head.length, dp.getLength());
        if (this.encapsulation != null) {
            buf = this.encapsulation.udpEncapsulate(buf, true);
        }
        super.send(new DatagramPacket(buf, buf.length, this.relayIP, this.relayPort));
    }

    public void send(DatagramPacket dp, String host) throws IOException {
        if (this.proxy.isDirect(host)) {
            dp.setAddress(InetAddress.getByName(host));
            super.send(dp);
            return;
        }
        if (this.proxy.resolveAddrLocally) {
            dp.setAddress(InetAddress.getByName(host));
        }
        byte[] head = this.formHeader(host, dp.getPort());
        byte[] buf = new byte[head.length + dp.getLength()];
        byte[] data = dp.getData();
        System.arraycopy(head, 0, buf, 0, head.length);
        System.arraycopy(data, 0, buf, head.length, dp.getLength());
        if (this.encapsulation != null) {
            buf = this.encapsulation.udpEncapsulate(buf, true);
        }
        super.send(new DatagramPacket(buf, buf.length, this.relayIP, this.relayPort));
    }

    public void receive(DatagramPacket dp) throws IOException {
        super.receive(dp);
        if (this.server_mode) {
            int init_length = dp.getLength();
            int initTimeout = this.getSoTimeout();
            long startTime = System.currentTimeMillis();
            while (!this.relayIP.equals(dp.getAddress()) || this.relayPort != dp.getPort()) {
                dp.setLength(init_length);
                if (initTimeout != 0) {
                    int newTimeout = initTimeout - (int)(System.currentTimeMillis() - startTime);
                    if (newTimeout <= 0) {
                        throw new InterruptedIOException("In Socks5DatagramSocket->receive()");
                    }
                    this.setSoTimeout(newTimeout);
                }
                super.receive(dp);
            }
            if (initTimeout != 0) {
                this.setSoTimeout(initTimeout);
            }
        } else if (!this.relayIP.equals(dp.getAddress()) || this.relayPort != dp.getPort()) {
            return;
        }
        byte[] data = dp.getData();
        if (this.encapsulation != null) {
            data = this.encapsulation.udpEncapsulate(data, false);
        }
        int offset = 0;
        ByteArrayInputStream bIn = new ByteArrayInputStream(data, offset, dp.getLength());
        Socks5Message msg = new Socks5Message(bIn);
        dp.setPort(msg.port);
        dp.setAddress(((ProxyMessage)msg).getInetAddress());
        int data_length = bIn.available();
        System.arraycopy(data, offset + dp.getLength() - data_length, data, offset, data_length);
        dp.setLength(data_length);
    }

    public int getLocalPort() {
        if (this.server_mode) {
            return super.getLocalPort();
        }
        return this.relayPort;
    }

    public InetAddress getLocalAddress() {
        if (this.server_mode) {
            return super.getLocalAddress();
        }
        return this.relayIP;
    }

    public void close() {
        if (!this.server_mode) {
            this.proxy.endSession();
        }
        super.close();
    }

    public boolean isProxyAlive(int timeout) {
        if (this.server_mode) {
            return false;
        }
        if (this.proxy != null) {
            try {
                this.proxy.proxySocket.setSoTimeout(timeout);
                int eof = this.proxy.in.read();
                return eof >= 0;
            }
            catch (InterruptedIOException iioe) {
                return true;
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return false;
    }

    private byte[] formHeader(InetAddress ip, int port) {
        Socks5Message request = new Socks5Message(0, ip, port);
        request.data[0] = 0;
        return request.data;
    }

    private byte[] formHeader(String host, int port) {
        Socks5Message request = new Socks5Message(0, host, port);
        request.data[0] = 0;
        return request.data;
    }
}

