/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import net.sf.jml.exception.JmlException;
import net.sf.jml.util.DigestUtils;
import net.sf.jml.util.StringUtils;

public final class MsnObject {
    public static final int TYPE_CUSTOM_EMOTICON = 2;
    public static final int TYPE_DISPLAY_PICTURE = 3;
    public static final int TYPE_BACKGROUND = 5;
    public static final int TYPE_DYNAMIC_DISPLAY_PICTURE = 7;
    public static final int TYPE_WINKS = 8;
    public static final int TYPE_VOICE_CLIP = 11;
    public static final int TYPE_ADDIN_SAVED_STATE = 12;
    public static final int TYPE_MSNP15_LOCATION = 14;
    private String creator = "";
    private long size = 0L;
    private int type = 3;
    private String location = "0";
    private String friendly = "AAA=";
    private String sha1d = "";
    private String sha1c = "";
    private byte[] msnObj;

    public static MsnObject getInstance(String string, byte[] byArray) throws JmlException {
        if (string == null) {
            throw new JmlException("Creator can't null!");
        }
        if (byArray == null) {
            throw new JmlException("Picture can't null!");
        }
        return new MsnObject(string, byArray);
    }

    public static MsnObject getInstance(String string, String string2) throws JmlException {
        byte[] byArray;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
            byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JmlException("File " + string2 + " not found!", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new JmlException("File " + string2 + " can't access!", iOException);
        }
        return MsnObject.getInstance(string, byArray);
    }

    public static MsnObject parseMsnObject(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().length() == 0) {
            return null;
        }
        try {
            MsnObject msnObject = new MsnObject();
            string = string.substring(8, string.length() - 2);
            int n = 0;
            int n2 = 0;
            while (n2 < string.length()) {
                while (string.charAt(n2) != '=') {
                    ++n2;
                }
                String string2 = string.substring(n, n2);
                char c = string.charAt(n2 + 1);
                n2 = n = n2 + 2;
                while (string.charAt(n2) != c) {
                    ++n2;
                }
                String string3 = string.substring(n, n2);
                if (string2.equalsIgnoreCase("Creator")) {
                    msnObject.creator = string3;
                } else if (string2.equalsIgnoreCase("Size")) {
                    msnObject.size = Long.parseLong(string3);
                } else if (string2.equalsIgnoreCase("Type")) {
                    msnObject.type = Integer.parseInt(string3);
                } else if (string2.equalsIgnoreCase("Location")) {
                    msnObject.location = string3;
                } else if (string2.equalsIgnoreCase("Friendly")) {
                    msnObject.friendly = string3;
                } else if (string2.equalsIgnoreCase("SHA1D")) {
                    msnObject.sha1d = string3;
                } else if (string2.equalsIgnoreCase("SHA1C")) {
                    msnObject.sha1c = string3;
                }
                for (n = n2 + 1; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
                }
                n2 = n;
            }
            if (msnObject.sha1c.length() == 0) {
                msnObject.generate();
            }
            return msnObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private MsnObject() {
    }

    private MsnObject(String string, byte[] byArray) {
        this.creator = string;
        this.msnObj = byArray;
        this.size = byArray.length;
        this.generate();
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        this.creator = string;
        this.generate();
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l) {
        this.size = l;
        this.generate();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
        this.generate();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
        this.generate();
    }

    public String getFriendly() {
        return this.friendly;
    }

    public void setFriendly(String string) {
        if (string == null) {
            return;
        }
        try {
            string = StringUtils.encodeBase64(string.getBytes("UTF-16BE"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = StringUtils.encodeBase64(string.getBytes());
        }
        this.friendly = string;
        this.generate();
    }

    public String getSha1d() {
        return this.sha1d;
    }

    public void setSha1d(String string) {
        this.sha1d = string;
    }

    public String getSha1c() {
        return this.sha1c;
    }

    public void setSha1c(String string) {
        this.sha1c = string;
    }

    public byte[] getMsnObj() {
        return this.msnObj;
    }

    private void generate() {
        if (this.msnObj != null) {
            this.sha1d = StringUtils.encodeBase64(DigestUtils.sha1(this.msnObj));
        }
        String string = "Creator" + this.getCreator() + "Size" + this.size + "Type" + this.getType() + "Location" + this.getLocation() + "Friendly" + this.getFriendly() + "SHA1D" + this.sha1d;
        this.sha1c = StringUtils.encodeBase64(DigestUtils.sha1(string.getBytes()));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<msnobj Creator=");
        stringBuffer.append("\"").append(this.getCreator()).append("\"");
        stringBuffer.append(" Size=");
        stringBuffer.append("\"").append(this.getSize()).append("\"");
        stringBuffer.append(" Type=");
        stringBuffer.append("\"").append(this.getType()).append("\"");
        stringBuffer.append(" Location=");
        stringBuffer.append("\"").append(this.getLocation()).append("\"");
        stringBuffer.append(" Friendly=");
        stringBuffer.append("\"").append(this.getFriendly()).append("\"");
        stringBuffer.append(" SHA1D=");
        stringBuffer.append("\"").append(this.getSha1d()).append("\"");
        stringBuffer.append(" SHA1C=");
        stringBuffer.append("\"").append(this.getSha1c()).append("\"");
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this.getSha1c() == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof MsnObject)) {
            return false;
        }
        return this.getSha1c().equals(((MsnObject)object).getSha1c());
    }

    public int hashCode() {
        if (this.getSha1c() == null) {
            return 0;
        }
        return this.getSha1c().hashCode();
    }
}

