/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets;

import java.nio.ByteBuffer;
import net.sf.jqql.Util;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.debug.PacketDO;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08Packet;

public abstract class _08OutPacket
extends _08Packet {
    protected static char seq = (char)Util.random().nextInt();
    protected boolean ack;
    protected int resendCountDown;
    protected long timeout;
    protected int sendCount;

    public _08OutPacket(byte by, char c, boolean bl, QQUser qQUser) {
        super(by, '\u115b', c, _08OutPacket.getNextSeq(), qQUser);
        this.ack = bl;
        this.resendCountDown = 4;
        this.sendCount = 1;
    }

    protected _08OutPacket(ByteBuffer byteBuffer, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, qQUser);
    }

    protected _08OutPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    protected void parseBody(ByteBuffer byteBuffer) throws PacketParseException {
    }

    protected abstract void postFill(ByteBuffer var1, int var2);

    public void fill(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        this.putHead(byteBuffer);
        bodyBuf.clear();
        this.putBody(bodyBuf);
        bodyBuf.flip();
        this.bodyDecrypted = new byte[bodyBuf.limit()];
        System.arraycopy(bodyBuf.array(), 0, this.bodyDecrypted, 0, this.bodyDecrypted.length);
        byte[] byArray = this.encryptBody(this.bodyDecrypted);
        byteBuffer.put(byArray);
        this.putTail(byteBuffer);
        this.postFill(byteBuffer, n);
        if (ds.isDebug()) {
            byte[] byArray2 = this.dump();
            PacketDO packetDO = new PacketDO(this.getPacketName(), byArray2, false, this.getHeadLength(), byArray2.length - this.getTailLength());
            ds.deliverDebugObject(packetDO);
        }
    }

    public byte[] dump() {
        if (this.bodyDecrypted == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.getLength(this.bodyDecrypted.length)];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.putHead(byteBuffer);
        byteBuffer.put(this.bodyDecrypted);
        this.putTail(byteBuffer);
        this.postFill(byteBuffer, 0);
        byteBuffer = null;
        return byArray;
    }

    protected static char getNextSeq() {
        seq = (char)(seq + '\u0001');
        if ((seq = (char)(seq & Short.MAX_VALUE)) == '\u0000') {
            seq = (char)(seq + '\u0001');
        }
        return seq;
    }

    public String getPacketName() {
        return "Unknown Outcoming _08Packet";
    }

    public final boolean needResend() {
        return this.resendCountDown-- > 0;
    }

    public final boolean needAck() {
        return this.ack;
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(long l) {
        this.timeout = l;
    }

    public final void setSendCount(int n) {
        this.sendCount = n;
    }

    public final int getSendCount() {
        return this.sendCount;
    }
}

