/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets;

import java.nio.ByteBuffer;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08InPacket;

public abstract class _08BasicInPacket
extends _08InPacket {
    public _08BasicInPacket(char c, QQUser qQUser) {
        super((byte)2, '\u0100', c, qQUser);
    }

    public _08BasicInPacket(ByteBuffer byteBuffer, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, qQUser);
    }

    public _08BasicInPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    protected void parseHeader(ByteBuffer byteBuffer) throws PacketParseException {
        if (!this.user.isUdp()) {
            byteBuffer.getChar();
        }
        this.header = byteBuffer.get();
        this.source = byteBuffer.getChar();
        this.command = byteBuffer.getChar();
        this.sequence = byteBuffer.getChar();
    }

    protected void parseTail(ByteBuffer byteBuffer) {
        byteBuffer.get();
    }

    protected void putHead(ByteBuffer byteBuffer) {
        if (!this.user.isUdp()) {
            byteBuffer.putChar('\u0000');
        }
        byteBuffer.put(this.getHeader());
        byteBuffer.putChar(this.source);
        byteBuffer.putChar(this.command);
        byteBuffer.putChar(this.sequence);
    }

    protected void putBody(ByteBuffer byteBuffer) {
    }

    protected void putTail(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)3);
    }

    public String getPacketName() {
        return "Unknown Incoming _08Packet - 0x" + Integer.toHexString(this.command).toUpperCase();
    }

    protected byte[] encryptBody(byte[] byArray) {
        return null;
    }

    protected byte[] getBodyBytes(ByteBuffer byteBuffer, int n) {
        int n2 = n - 7 - 1;
        if (!this.user.isUdp()) {
            n2 -= 2;
        }
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return byArray;
    }

    protected int getLength(int n) {
        return 8 + n + (this.user.isUdp() ? 0 : 2);
    }

    protected int getHeadLength() {
        return 7 + (this.user.isUdp() ? 0 : 2);
    }

    protected int getTailLength() {
        return 1;
    }

    public byte[] getDecryptKey(byte[] byArray) {
        return this.user.getSessionKey();
    }

    public byte[] getEncryptKey(byte[] byArray) {
        return this.user.getSessionKey();
    }

    public byte[] getFallbackDecryptKey(byte[] byArray) {
        return this.user.getPasswordKey();
    }

    public int getFamily() {
        return 1;
    }
}

