/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import net.sf.jqql.net.INIOHandler;
import net.sf.jqql.net.IProxy;
import net.sf.jqql.net.IProxyHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractProxy
implements IProxy,
INIOHandler {
    private static final Log log = LogFactory.getLog(AbstractProxy.class);
    protected SocketChannel socketChannel;
    protected DatagramChannel datagramChannel;
    protected IProxyHandler handler;
    protected ByteBuffer buffer;
    protected String username;
    protected String password;
    protected InetSocketAddress serverAddress;
    protected InetSocketAddress proxyAddress;
    protected int status;
    protected boolean connected;
    protected boolean udp;
    protected int clientPort;

    public AbstractProxy(IProxyHandler iProxyHandler) throws IOException {
        this.handler = iProxyHandler;
        this.buffer = ByteBuffer.allocateDirect(300);
        this.password = "";
        this.username = "";
        this.connected = false;
        this.udp = false;
        this.socketChannel = SocketChannel.open();
        this.socketChannel.configureBlocking(false);
    }

    public AbstractProxy(IProxyHandler iProxyHandler, DatagramChannel datagramChannel) {
        this.handler = iProxyHandler;
        this.buffer = ByteBuffer.allocateDirect(300);
        this.password = "";
        this.username = "";
        this.connected = true;
        this.udp = true;
        this.datagramChannel = datagramChannel;
    }

    public SelectableChannel channel() {
        if (this.socketChannel != null) {
            return this.socketChannel;
        }
        return this.datagramChannel;
    }

    public INIOHandler getNIOHandler() {
        return this;
    }

    protected void send() {
        try {
            if (this.connected) {
                if (this.socketChannel != null) {
                    this.socketChannel.write(this.buffer);
                }
                if (this.datagramChannel != null) {
                    this.datagramChannel.write(this.buffer);
                }
            }
        }
        catch (IOException iOException) {
            log.error((Object)iOException.getMessage());
            this.handler.proxyError(iOException.getMessage());
        }
    }

    protected void receive() {
        try {
            this.buffer.clear();
            if (this.socketChannel != null) {
                int n = this.socketChannel.read(this.buffer);
                while (n > 0) {
                    n = this.socketChannel.read(this.buffer);
                }
            } else {
                this.datagramChannel.receive(this.buffer);
            }
            this.buffer.flip();
        }
        catch (IOException iOException) {
            log.error((Object)iOException.getMessage());
            this.handler.proxyError(iOException.getMessage());
        }
    }

    public void start() {
        try {
            if (this.socketChannel != null) {
                this.socketChannel.connect(this.proxyAddress);
            }
            if (this.datagramChannel != null) {
                this.datagramChannel.connect(this.proxyAddress);
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage());
            this.handler.proxyError(exception.getMessage());
        }
    }

    public void dispose() {
        try {
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
            if (this.datagramChannel != null) {
                this.datagramChannel.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processConnect(SelectionKey selectionKey) throws IOException {
        if (this.connected) {
            return;
        }
        this.socketChannel.finishConnect();
        while (!this.socketChannel.isConnected()) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.socketChannel.finishConnect();
        }
        selectionKey.interestOps(1);
        this.connected = true;
        log.debug((Object)"\u5df2\u8fde\u63a5\u4e0a\u4ee3\u7406\u670d\u52a1\u5668");
    }

    public void processError(Exception exception) {
        this.handler.proxyError(exception.getMessage());
    }

    public void setProxyAddress(InetSocketAddress inetSocketAddress) {
        this.proxyAddress = inetSocketAddress;
    }

    public void setRemoteAddress(InetSocketAddress inetSocketAddress) {
        this.serverAddress = inetSocketAddress;
    }

    public void setClientPort(int n) {
        this.clientPort = n;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }
}

