/*
 * Decompiled with CFR 0.152.
 */
package redstone.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import redstone.xmlrpc.XmlRpcJsonSerializer;
import redstone.xmlrpc.XmlRpcServer;

public class XmlRpcServlet
extends HttpServlet {
    private XmlRpcServer server;
    private boolean streamMessages;
    private String contentType;
    private static final long serialVersionUID = 3544388119488050993L;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string = servletConfig.getInitParameter("contentType");
        String string2 = servletConfig.getInitParameter("streamMessages");
        if (string2 != null && string2.equals("1")) {
            this.streamMessages = true;
        }
        if (string != null && string.startsWith("text/javascript+json")) {
            this.server = new XmlRpcServer(new XmlRpcJsonSerializer());
        } else {
            this.server = new XmlRpcServer();
            if (string == null) {
                string = "text/xml; charset=ISO-8859-1";
            }
        }
    }

    public XmlRpcServer getXmlRpcServer() {
        return this.server;
    }

    public boolean getStreamMessages() {
        return this.streamMessages;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType(this.contentType);
        if (this.streamMessages) {
            this.server.execute((InputStream)httpServletRequest.getInputStream(), httpServletResponse.getWriter());
            httpServletResponse.getWriter().flush();
        } else {
            Writer writer = new StringWriter(2048);
            this.server.execute((InputStream)httpServletRequest.getInputStream(), writer);
            String string = writer.toString();
            httpServletResponse.setContentLength(string.length());
            writer = httpServletResponse.getWriter();
            writer.write(string);
            writer.flush();
        }
    }
}

