/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.chatui;

import com.lotus.sametime.core.constants.MeetingTypes;
import java.util.Vector;

public class ChatConstants {
    public static final int USER_STARTED_RESPONSE = 8;
    public static final int DB_SERVER_PORT = 8081;
    public static final int T120_MEETING_ID = 9010;
    public static final int SCHEDULED = 2;
    public static final int INSTANT = 1;
    public static final int VISIBLE_DATA_ACTIVITY = 9007;
    public static final int STARTING_TIME = 9006;
    public static final int MODERATOR = 9005;
    public static final int MEETING_KIND = 9004;
    public static final int REQUESTED_ACTIVITIES = 9002;
    public static final int ST_QUESTION_AND_ANSWER_ACTIVITY = 37130;
    public static final int ST_URL_PUSH_ACTIVITY = 37129;
    public static final int ST_WHITEBOARD_ACTIVITY = 37121;
    public static final int ST_SCREEN_SHARE_ACTIVITY = 37122;
    public static final int ST_VIDEO_ACTIVITY = 37124;
    public static final int ST_AUDIO_ACTIVITY = 37123;
    public static final int ST_CHAT_ACTIVITY = 37126;

    public static Vector getActivities(MeetingTypes meetingTypes, boolean bl) {
        Vector<Integer> vector = new Vector<Integer>();
        if (meetingTypes.equals(MeetingTypes.ST_CHAT_MEETING)) {
            vector.addElement(new Integer(37126));
        } else if (meetingTypes.equals(MeetingTypes.ST_AUDIO_MEETING)) {
            if (bl) {
                vector.addElement(new Integer(37126));
            }
            vector.addElement(new Integer(37123));
        } else if (meetingTypes.equals(MeetingTypes.ST_VIDEO_MEETING)) {
            if (bl) {
                vector.addElement(new Integer(37126));
            }
            vector.addElement(new Integer(37123));
            vector.addElement(new Integer(37124));
        } else if (meetingTypes.equals(MeetingTypes.ST_SHARE_MEETING)) {
            if (bl) {
                vector.addElement(new Integer(37126));
            }
            vector.addElement(new Integer(37122));
            vector.addElement(new Integer(37121));
            vector.addElement(new Integer(37130));
            vector.addElement(new Integer(37129));
        } else if (meetingTypes.equals(MeetingTypes.ST_COLLABORATION_MEETING)) {
            vector.addElement(new Integer(37126));
            vector.addElement(new Integer(37123));
            vector.addElement(new Integer(37124));
            vector.addElement(new Integer(37122));
            vector.addElement(new Integer(37121));
            vector.addElement(new Integer(37130));
            vector.addElement(new Integer(37129));
        }
        return vector;
    }

    public static MeetingTypes getMeetingType(Vector vector) {
        MeetingTypes meetingTypes = null;
        Vector vector2 = (Vector)vector.clone();
        if (vector2.size() == 2 && vector2.contains(new Integer(37126))) {
            vector2.removeElement(new Integer(37126));
        }
        if (vector2.size() == 1) {
            int n2 = (Integer)vector2.firstElement();
            if (n2 == 37126) {
                meetingTypes = MeetingTypes.ST_CHAT_MEETING;
            } else if (n2 == 37123) {
                meetingTypes = MeetingTypes.ST_AUDIO_MEETING;
            } else if (n2 == 37124) {
                meetingTypes = MeetingTypes.ST_VIDEO_MEETING;
            } else if (n2 == 37121 || n2 == 37122) {
                meetingTypes = MeetingTypes.ST_SHARE_MEETING;
            }
        } else {
            boolean bl = false;
            boolean bl2 = false;
            if (vector2.contains(new Integer(37123)) && vector2.contains(new Integer(37124))) {
                bl = true;
                meetingTypes = MeetingTypes.ST_VIDEO_MEETING;
            }
            if (vector2.contains(new Integer(37122)) && vector2.contains(new Integer(37121))) {
                bl2 = true;
                meetingTypes = MeetingTypes.ST_SHARE_MEETING;
            }
            if (bl && bl2) {
                meetingTypes = MeetingTypes.ST_COLLABORATION_MEETING;
            }
            if (vector2.size() >= 3) {
                meetingTypes = MeetingTypes.ST_COLLABORATION_MEETING;
            }
            if (meetingTypes == null) {
                meetingTypes = MeetingTypes.ST_COLLABORATION_MEETING;
            }
        }
        return meetingTypes;
    }
}

