/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.IUser;

public class User
implements IUser {
    private static final Log LOGGER = LogFactory.getLog((Class)User.class);
    private int m_uin = -1;
    private UserMode m_userMode = null;

    public User(int uin) {
        this(uin, UserMode.BUDDY);
    }

    public User(int uin, UserMode userMode) {
        if (uin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        if (userMode == null) {
            throw new NullPointerException("userMode cannot be null");
        }
        this.m_uin = uin;
        this.m_userMode = userMode;
    }

    public int getUin() {
        return this.m_uin;
    }

    public UserMode getUserMode() {
        return this.m_userMode;
    }

    public void setUserMode(UserMode userMode) {
        if (userMode == null) {
            throw new NullPointerException("userMode cannot be null");
        }
        this.m_userMode = userMode;
    }

    public boolean equals(Object o) {
        IUser user;
        return o instanceof IUser && (user = (IUser)o).getUin() == this.m_uin;
    }

    public int hashCode() {
        return this.m_uin;
    }

    public String toString() {
        return "[Uin: " + this.m_uin + ", userMode: " + this.m_userMode + "]";
    }

    public static class UserMode {
        private String m_type = null;
        public static final UserMode BUDDY = new UserMode("user_mode_buddy");
        public static final UserMode FRIEND = new UserMode("user_mode_friend");
        public static final UserMode BLOCKED = new UserMode("user_mode_blocked");
        public static final UserMode UNKNOWN = new UserMode("user_mode_unknown");

        private UserMode(String type) {
            this.m_type = type;
        }

        public String toString() {
            return this.m_type;
        }

        public int hashCode() {
            return this.m_type.hashCode() * 37;
        }
    }
}

