/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr;

import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.State;
import java.util.Observable;
import java.util.Observer;

public abstract class GenericCommandAutoService
implements Observer {
    protected boolean enabled = false;
    protected IRCConnection connection;

    protected GenericCommandAutoService(IRCConnection connection) {
        this.connection = connection;
        this.enable();
    }

    public synchronized void enable() {
        if (this.enabled) {
            return;
        }
        this.connection.addCommandObserver(this);
        this.enabled = true;
    }

    public synchronized void disable() {
        if (!this.enabled) {
            return;
        }
        this.connection.removeCommandObserver(this);
        this.enabled = false;
    }

    public synchronized void update(Observable observer, Object updated) {
        if (!this.enabled) {
            throw new IllegalStateException("This observer is not enabled.");
        }
        if (updated instanceof State) {
            throw new IllegalArgumentException("This is not a state observer.");
        }
        if (!(updated instanceof InCommand)) {
            throw new IllegalArgumentException("Unknown object given to update.");
        }
        this.updateCommand((InCommand)updated);
    }

    protected IRCConnection getConnection() {
        return this.connection;
    }

    protected synchronized boolean isEnabled() {
        return this.enabled;
    }

    protected abstract void updateCommand(InCommand var1);
}

