/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.out;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08BasicOutPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FriendLevelOpPacket
extends _08BasicOutPacket {
    private List<Integer> friends;
    private byte subCommand;

    public FriendLevelOpPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public FriendLevelOpPacket(QQUser qQUser) {
        super('\\', true, qQUser);
        this.subCommand = (byte)2;
    }

    @Override
    protected void putBody(ByteBuffer byteBuffer) {
        byteBuffer.put(this.subCommand);
        for (int n : this.friends) {
            byteBuffer.putInt(n);
        }
    }

    @Override
    public String getPacketName() {
        return "Get Friends Level _08Packet";
    }

    public byte getSubCommand() {
        return this.subCommand;
    }

    public void setSubCommand(byte by) {
        this.subCommand = by;
    }

    public List<Integer> getFriends() {
        return this.friends;
    }

    public void setFriends(List<Integer> list) {
        this.friends = list;
    }

    public void addFriend(int n) {
        if (this.friends == null) {
            this.friends = new ArrayList<Integer>();
        }
        this.friends.add(n);
    }
}

