/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openymsg.addressBook.YahooAddressBookEntry;
import org.openymsg.network.Status;
import org.openymsg.network.YahooProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooUser {
    protected final String userId;
    private final Set<String> groupIds;
    protected Status status = Status.OFFLINE;
    protected int stealth;
    protected boolean onChat = false;
    protected boolean onPager = false;
    protected boolean ignored = false;
    protected boolean stealthBlocked = false;
    protected String customStatusMessage;
    protected String customStatus;
    private long idleTime = -1L;
    private YahooAddressBookEntry addressBookEntry = YahooAddressBookEntry.EMPTY;
    private YahooProtocol protocol;

    public YahooProtocol getProtocol() {
        return this.protocol;
    }

    public YahooUser(String userId, String groupId, YahooProtocol protocol) {
        this.userId = userId.toLowerCase();
        this.groupIds = new HashSet<String>();
        if (groupId != null && groupId.length() != 0) {
            this.groupIds.add(groupId);
        }
        this.protocol = protocol;
    }

    public YahooUser(String userId, String groupId, YahooProtocol protocol, YahooAddressBookEntry addressBookEntry) {
        this(userId, groupId, protocol);
        this.addressBookEntry = addressBookEntry;
    }

    public YahooUser(String userId, Set<String> groupIds, YahooProtocol protocol) {
        this.userId = userId.toLowerCase();
        this.groupIds = groupIds;
        this.protocol = protocol;
    }

    public YahooUser(String userId, Set<String> groupIds, YahooProtocol protocol, YahooAddressBookEntry addressBookEntry) {
        this(userId, groupIds, protocol);
        this.addressBookEntry = addressBookEntry;
    }

    public YahooUser(String userId) {
        this(userId, (String)null, YahooProtocol.YAHOO);
    }

    public YahooUser(String userId, YahooAddressBookEntry addressBookEntry) {
        this(userId);
        this.addressBookEntry = addressBookEntry;
    }

    public String getId() {
        return this.userId;
    }

    void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    void setStealthBlocked(boolean blocked) {
        this.stealthBlocked = blocked;
    }

    public boolean isStealthBlocked() {
        return this.stealthBlocked;
    }

    public void setCustom(String message, String status) {
        this.customStatusMessage = message;
        this.customStatus = status;
    }

    public String getCustomStatusMessage() {
        return this.customStatusMessage;
    }

    public String getCustomStatus() {
        return this.customStatus;
    }

    void setIdleTime(long seconds) {
        this.idleTime = seconds;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    void setStealth(int stealth) {
        this.stealth = stealth;
    }

    public int getStealth() {
        return this.stealth;
    }

    public void addGroupId(String groupId) {
        this.groupIds.add(groupId);
    }

    public Set<String> getGroupIds() {
        return Collections.unmodifiableSet(this.groupIds);
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isOnChat() {
        return this.onChat;
    }

    public boolean isOnPager() {
        return this.onPager;
    }

    public boolean isLoggedIn() {
        return this.onChat || this.onPager;
    }

    public boolean isFriend() {
        return !this.groupIds.isEmpty();
    }

    public boolean isAnonymous() {
        return !this.isFriend();
    }

    public String toString() {
        return "YahooUser [ID=" + this.userId + ", status=" + this.status.name() + ", ignored=" + this.ignored + ", stealthBlock=" + this.stealthBlocked + ", customStatusMessage=" + this.customStatusMessage + ", isFriend=" + this.isFriend() + ", protocol=" + (Object)((Object)this.protocol) + ", ab=" + this.addressBookEntry + "]";
    }

    public int hashCode() {
        return this.userId == null ? 1 : this.userId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof YahooUser)) {
            return false;
        }
        YahooUser other = (YahooUser)obj;
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }

    public void update(Status newStatus, String newVisibility) {
        int iVisibility = newVisibility == null ? 0 : Integer.parseInt(newVisibility);
        this.update(newStatus, (iVisibility & 2) > 0, (iVisibility & 1) > 0);
    }

    public void update(Status newStatus, boolean newOnChat, boolean newOnPager) {
        this.update(newStatus);
        this.onChat = newOnChat;
        this.onPager = newOnPager;
    }

    public void update(Status newStatus) {
        this.status = newStatus;
        if (this.status != Status.CUSTOM) {
            this.customStatusMessage = null;
            this.customStatus = null;
        }
    }

    public String getFirstName() {
        return this.addressBookEntry.getFirstName();
    }

    public String getLastName() {
        return this.addressBookEntry.getLastName();
    }

    public String getNickName() {
        return this.addressBookEntry.getNickName();
    }

    public YahooAddressBookEntry getAddressBookEntry() {
        return this.addressBookEntry;
    }

    public void update(YahooProtocol protocol) {
        this.protocol = protocol;
    }
}

